/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.File;
import java.util.Locale;

public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;

    private FileUtils() {
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtils.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtils.removeDir(f);
                continue;
            }
            FileUtils.delete(f);
        }
        FileUtils.delete(d);
    }

    private static void delete(File f) {
        if (!f.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }
}

