/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import org.apache.cxf.jaxb.JAXBUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WrapperHelper {
    private WrapperHelper() {
    }

    public static void setWrappedPart(String partName, Object wrapperType, Object part) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (part instanceof List) {
            WrapperHelper.setWrappedListProperty(partName, wrapperType, part);
        } else {
            String fieldName = partName;
            if (JAXBUtils.isJavaKeyword(partName)) {
                fieldName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.VARIABLE);
            }
            XmlElement el = null;
            for (Field field : wrapperType.getClass().getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                el = field.getAnnotation(XmlElement.class);
            }
            if (part == null) {
                if (el != null && !el.nillable()) {
                    throw new IllegalArgumentException("null value for field not permitted.");
                }
                return;
            }
            String modifier = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.SETTER);
            boolean setInvoked = false;
            for (Method method : wrapperType.getClass().getMethods()) {
                if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !modifier.equals(method.getName())) continue;
                method.invoke(wrapperType, part);
                setInvoked = true;
                break;
            }
            if (!setInvoked) {
                throw new IllegalArgumentException("Could not find a modifier method on Wrapper Type for " + partName);
            }
        }
    }

    private static void setWrappedListProperty(String partName, Object wrapperType, Object part) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessorName = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        for (Method method : wrapperType.getClass().getMethods()) {
            if (!accessorName.equals(method.getName()) || !List.class.isAssignableFrom(method.getReturnType())) continue;
            Object ret = method.invoke(wrapperType, new Object[0]);
            Method addAll = ret.getClass().getMethod("addAll", Collection.class);
            addAll.invoke(ret, part);
            break;
        }
    }

    public static Object getWrappedPart(String partName, Object wrapperType, Class<?> partClazz) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        if (partClazz.equals(Boolean.TYPE) || partClazz.equals(Boolean.class)) {
            accessor = accessor.replaceFirst("get", "is");
        }
        for (Method method : wrapperType.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !accessor.equals(method.getName())) continue;
            return method.invoke(wrapperType, new Object[0]);
        }
        return null;
    }

    public static Object getWrappedPart(String partName, Object wrapperType, String elementType) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        if (elementType != null && "boolean".equals(elementType.toLowerCase())) {
            accessor = accessor.replaceFirst("get", "is");
        }
        for (Method method : wrapperType.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !accessor.equals(method.getName())) continue;
            return method.invoke(wrapperType, new Object[0]);
        }
        return null;
    }

    public static Object getWrappedPart(String partName, Object wrapperType) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        String accessor = JAXBUtils.nameToIdentifier(partName, JAXBUtils.IdentifierType.GETTER);
        for (Method method : wrapperType.getClass().getMethods()) {
            if (method.getParameterTypes().length != 0 || !accessor.equals(method.getName())) continue;
            return method.invoke(wrapperType, new Object[0]);
        }
        return null;
    }
}

