/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Port;
import javax.wsdl.extensions.http.HTTPAddress;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.security.SSLClientPolicy;
import org.apache.cxf.configuration.security.SSLServerPolicy;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.AbstractTransportFactory;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.JettyHTTPDestination;
import org.apache.cxf.transport.http.JettyListenerFactory;
import org.apache.cxf.transport.http.URLConnectionFactory;
import org.apache.cxf.transport.https.HttpsURLConnectionFactory;
import org.apache.cxf.transport.https.JettySslListenerFactory;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;
import org.mortbay.http.SocketListener;
import org.mortbay.util.InetAddrPort;
import org.xmlsoap.schemas.wsdl.http.AddressType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPTransportFactory
extends AbstractTransportFactory
implements ConduitInitiator,
DestinationFactory,
WSDLEndpointFactory {
    private static final Set<String> URI_PREFIXES = new HashSet<String>();
    private Bus bus;
    private Collection<String> activationNamespaces;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    void registerWithBindingManager() {
        DestinationFactoryManager dfm;
        if (null == this.bus) {
            return;
        }
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        if (null != cim) {
            for (String ns : this.activationNamespaces) {
                cim.registerConduitInitiator(ns, (ConduitInitiator)this);
            }
        }
        if (null != (dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class))) {
            for (String ns : this.activationNamespaces) {
                dfm.registerDestinationFactory(ns, (DestinationFactory)this);
            }
        }
    }

    public Conduit getConduit(EndpointInfo endpointInfo) throws IOException {
        return this.getConduit(endpointInfo, null);
    }

    public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
        HTTPConduit conduit = target == null ? new HTTPConduit(this.bus, endpointInfo) : new HTTPConduit(this.bus, endpointInfo, target);
        this.configure((Object)conduit);
        conduit.retrieveConnectionFactory();
        return conduit;
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        JettyHTTPDestination destination = new JettyHTTPDestination(this.bus, this, endpointInfo);
        this.configure((Object)destination);
        destination.retrieveEngine();
        return destination;
    }

    public EndpointInfo createEndpointInfo(ServiceInfo serviceInfo, BindingInfo b, Port port) {
        List ees = port.getExtensibilityElements();
        for (Object extensor : ees) {
            if (extensor instanceof HTTPAddress) {
                HTTPAddress httpAdd = (HTTPAddress)extensor;
                EndpointInfo info = new EndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
                info.setAddress(httpAdd.getLocationURI());
                return info;
            }
            if (!(extensor instanceof AddressType)) continue;
            AddressType httpAdd = (AddressType)extensor;
            EndpointInfo info = new EndpointInfo(serviceInfo, "http://schemas.xmlsoap.org/wsdl/http/");
            info.setAddress(httpAdd.getLocation());
            return info;
        }
        return null;
    }

    public void createPortExtensors(EndpointInfo ei, Service service) {
    }

    public Set<String> getUriPrefixes() {
        return URI_PREFIXES;
    }

    protected void configure(Object bean) {
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(bean);
        }
    }

    protected static URLConnectionFactory getConnectionFactory(SSLClientPolicy policy) {
        return policy == null ? new URLConnectionFactory(){

            public URLConnection createConnection(Proxy proxy, URL u) throws IOException {
                return proxy != null ? u.openConnection(proxy) : u.openConnection();
            }
        } : new HttpsURLConnectionFactory(policy);
    }

    protected static JettyListenerFactory getListenerFactory(SSLServerPolicy policy) {
        return policy == null ? new JettyListenerFactory(){

            public SocketListener createListener(int port) {
                return new SocketListener(new InetAddrPort(port));
            }
        } : new JettySslListenerFactory(policy);
    }

    static {
        URI_PREFIXES.add("http://");
        URI_PREFIXES.add("https://");
    }
}

