/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.configuration.security.SSLServerPolicy;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.JettyListenerFactory;
import org.apache.cxf.transport.http.ServerEngine;
import org.apache.cxf.transport.http.listener.HTTPListenerConfigBean;
import org.apache.cxf.transports.http.configuration.HTTPListenerPolicy;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.AbstractHttpHandler;

public final class JettyHTTPServerEngine
extends HTTPListenerConfigBean
implements ServerEngine {
    private static final long serialVersionUID = 1L;
    private static Map<Integer, JettyHTTPServerEngine> portMap = new HashMap<Integer, JettyHTTPServerEngine>();
    private int servantCount;
    private HttpServer server;
    private SocketListener listener;
    private JettyListenerFactory listenerFactory;
    private final int port;

    JettyHTTPServerEngine(Bus bus, String protocol, int p) {
        this.port = p;
    }

    public String getBeanName() {
        return JettyHTTPServerEngine.class.getName() + "." + this.port;
    }

    static synchronized JettyHTTPServerEngine getForPort(Bus bus, String protocol, int p) {
        return JettyHTTPServerEngine.getForPort(bus, protocol, p, null);
    }

    static synchronized JettyHTTPServerEngine getForPort(Bus bus, String protocol, int p, SSLServerPolicy sslServerPolicy) {
        JettyHTTPServerEngine ref = portMap.get(p);
        if (ref == null) {
            ref = new JettyHTTPServerEngine(bus, protocol, p);
            JettyHTTPServerEngine.configure(bus, ref);
            ref.init(sslServerPolicy);
            ref.retrieveListenerFactory();
            portMap.put(p, ref);
        }
        return ref;
    }

    public static synchronized void destroyForPort(int p) {
        JettyHTTPServerEngine ref = portMap.remove(p);
        if (ref != null && ref.server != null) {
            try {
                ref.listener.getServerSocket().close();
                ref.server.stop(true);
                ref.server.destroy();
                ref.server = null;
                ref.listener = null;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized void addServant(URL url, AbstractHttpHandler handler) {
        if (this.server == null) {
            this.server = new HttpServer();
            this.listener = this.listenerFactory.createListener(this.port);
            if (this.getListener().isSetMinThreads()) {
                this.listener.setMinThreads(this.getListener().getMinThreads().intValue());
            }
            if (this.getListener().isSetMaxThreads()) {
                this.listener.setMaxThreads(this.getListener().getMaxThreads().intValue());
            }
            if (this.getListener().isSetMaxIdleTimeMs()) {
                this.listener.setMaxIdleTimeMs(this.getListener().getMaxIdleTimeMs().intValue());
            }
            if (this.getListener().isSetLowResourcePersistTimeMs()) {
                int lowResourcePersistTime = this.getListener().getLowResourcePersistTimeMs().intValue();
                this.listener.setLowResourcePersistTimeMs(lowResourcePersistTime);
            }
            this.server.addListener((HttpListener)this.listener);
            try {
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.server.stop(true);
                    this.server.destroy();
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        String smap = HttpUriMapper.getResourceBase((String)url.getPath());
        HttpContext context = this.server.getContext(contextName);
        try {
            context.start();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if ("".equals(smap) && "".equals(contextName)) {
            handler.setName("/");
        } else {
            handler.setName(smap);
        }
        context.addHandler((HttpHandler)handler);
        try {
            handler.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ++this.servantCount;
    }

    public synchronized void removeServant(URL url) {
        String lpath = url.getPath();
        String contextName = "";
        String servletMap = lpath;
        int idx = lpath.lastIndexOf(47);
        if (idx > 0) {
            contextName = lpath.substring(0, idx);
            servletMap = lpath.substring(idx);
        }
        if ("".equals(servletMap) && "".equals(contextName)) {
            servletMap = "/";
        }
        boolean found = false;
        if (this.server != null) {
            HttpContext context = this.server.getContext(contextName);
            for (HttpHandler handler : context.getHandlers()) {
                if (!servletMap.equals(handler.getName())) continue;
                try {
                    handler.stop();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                context.removeHandler(handler);
                found = true;
            }
        }
        if (!found) {
            System.err.println("Not able to remove the handler");
        }
        --this.servantCount;
    }

    public synchronized HttpHandler getServant(URL url) {
        String lpath = url.getPath();
        String contextName = "";
        String servletMap = lpath;
        int idx = lpath.lastIndexOf(47);
        if (idx > 0) {
            contextName = lpath.substring(0, idx);
            servletMap = lpath.substring(idx);
        }
        HttpHandler ret = null;
        if (this.server != null) {
            HttpContext context = this.server.getContext(contextName);
            for (HttpHandler handler : context.getHandlers()) {
                if (!servletMap.equals(handler.getName())) continue;
                ret = handler;
                break;
            }
        }
        return ret;
    }

    protected static void configure(Bus bus, Object bean) {
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(bean);
        }
    }

    private void retrieveListenerFactory() {
        this.listenerFactory = HTTPTransportFactory.getListenerFactory(this.getSslServer());
    }

    private void init(SSLServerPolicy sslServerPolicy) {
        if (!this.isSetSslServer()) {
            this.setSslServer(sslServerPolicy);
        }
        if (!this.isSetListener()) {
            this.setListener(new HTTPListenerPolicy());
        }
    }
}

