/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes) {
        super(serviceInfo);
        this.classes = classes;
    }

    public void begin(MessagePartInfo part) {
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        Type genericType = (Type)part.getProperty("generic.type");
        if (genericType != null) {
            ParameterizedType pt;
            this.addType(genericType);
            if (Collection.class.isAssignableFrom(clazz) && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                Class<?> arrayCls;
                clazz = arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                part.setTypeClass(clazz);
            }
        }
        this.addClass(clazz);
    }

    private void addType(Type cls) {
        if (cls instanceof Class) {
            this.addClass((Class)cls);
        } else if (cls instanceof ParameterizedType) {
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
        }
    }

    private void addClass(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            return;
        }
        if (null != (cls = JAXBUtils.getValidClass(cls))) {
            if (cls.isEnum()) {
                this.classes.add(cls);
            }
            String name = PackageUtils.getPackageName((Class)cls) + ".ObjectFactory";
            try {
                cls = Class.forName(name, false, cls.getClassLoader());
                if (cls != null) {
                    this.classes.add(cls);
                }
            }
            catch (ClassNotFoundException ex) {
                this.classes.add(cls);
            }
        }
    }
}

