/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.attachment;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import org.apache.cxf.attachment.LazyDataSource;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;

public class JAXBAttachmentUnmarshaller
extends AttachmentUnmarshaller {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBAttachmentUnmarshaller.class);
    private Message message;

    public JAXBAttachmentUnmarshaller(Message messageParam) {
        this.message = messageParam;
    }

    public DataHandler getAttachmentAsDataHandler(String contentId) {
        return new DataHandler(this.getAttachmentDataSource(contentId));
    }

    public byte[] getAttachmentAsByteArray(String contentId) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            InputStream is = this.getAttachmentDataSource(contentId).getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            is.close();
            bos.close();
        }
        catch (IOException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("ATTACHMENT_READ_ERROR", LOG, new Object[0]), (Throwable)e);
        }
        return bos.toByteArray();
    }

    public boolean isXOPPackage() {
        return Boolean.TRUE.equals(this.message.getContextualProperty("mtom-enabled"));
    }

    private DataSource getAttachmentDataSource(String contentId) {
        if (contentId.startsWith("cid:")) {
            contentId = contentId.substring(4);
        }
        return new LazyDataSource(contentId, this.message.getAttachments());
    }
}

