/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb.io;

import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.jaxb.JAXBDataWriterFactory;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.MessagePartInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDataWriter
implements DataWriter<Message> {
    final JAXBDataWriterFactory factory;

    public MessageDataWriter(JAXBDataWriterFactory cb) {
        this.factory = cb;
    }

    public void write(Object obj, Message output) {
        this.write(obj, (MessagePartInfo)null, output);
    }

    public void write(Object obj, MessagePartInfo part, Message output) {
        JAXBAttachmentMarshaller am = null;
        if (Boolean.TRUE.equals(output.getContextualProperty("mtom-enabled"))) {
            am = new JAXBAttachmentMarshaller(output);
            am.setXOPPackage(true);
        }
        Object source = null;
        XMLStreamWriter xsw = (XMLStreamWriter)output.getContent(XMLStreamWriter.class);
        if (xsw != null) {
            source = xsw;
        } else {
            XMLEventWriter xew = (XMLEventWriter)output.getContent(XMLEventWriter.class);
            if (xew != null) {
                source = xew;
            } else {
                Node node = (Node)output.getContent(Node.class);
                source = node;
            }
        }
        if (source == null) {
            return;
        }
        if (obj != null) {
            JAXBEncoderDecoder.marshall(this.factory.getJAXBContext(), this.factory.getSchema(), obj, part, source, am);
        }
    }
}

