/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.naming.NamingException;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JMSProviderHub;
import org.apache.cxf.transport.jms.JMSTransportBase;
import org.apache.cxf.transport.jms.PooledSession;
import org.apache.cxf.transport.jms.ServiceModelJMSConfigurationProvider;
import org.apache.cxf.transport.jms.destination.JMSDestinationConfigBean;
import org.apache.cxf.transports.jms.JMSServerBehaviorPolicyType;
import org.apache.cxf.transports.jms.context.JMSMessageHeadersType;
import org.apache.cxf.transports.jms.jms_conf.JMSServerConfig;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JMSDestination
extends JMSTransportBase
implements Destination {
    static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    final EndpointReferenceType reference;
    final ConduitInitiator conduitInitiator;
    JMSDestinationConfigBean jmsDestinationConfigBean;
    PooledSession listenerSession;
    JMSListenerThread listenerThread;
    MessageObserver incomingObserver;

    public JMSDestination(Bus b, ConduitInitiator ci, EndpointInfo info) throws IOException {
        super(b, info, true);
        this.initConfig();
        this.conduitInitiator = ci;
        this.reference = new EndpointReferenceType();
        AttributedURIType address = new AttributedURIType();
        address.setValue(this.endpointInfo.getAddress());
        this.reference.setAddress(address);
    }

    public String getBeanName() {
        return this.endpointInfo.getName().toString() + ".jms-destination-base";
    }

    public EndpointReferenceType getAddress() {
        return this.reference;
    }

    public Conduit getBackChannel(org.apache.cxf.message.Message inMessage, org.apache.cxf.message.Message partialResponse, EndpointReferenceType address) throws IOException {
        BackChannelConduit backChannel = null;
        if (address == null) {
            backChannel = new BackChannelConduit(address, inMessage, this);
        } else if (partialResponse != null) {
            backChannel = new BackChannelConduit(address, inMessage, this);
        } else {
            backChannel = this.conduitInitiator.getConduit(this.endpointInfo, address);
            backChannel.setMessageObserver(new MessageObserver(){

                public void onMessage(org.apache.cxf.message.Message m) {
                    if (m.getContentFormats().contains(InputStream.class)) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        try {
                            is.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return backChannel;
    }

    public void setMessageObserver(MessageObserver observer) {
        if (null != observer) {
            try {
                this.activate();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            LOG.log(Level.FINE, "JMSDestination shutdown()");
            try {
                this.deactivate();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.incomingObserver = observer;
    }

    private void activate() throws IOException {
        LOG.log(Level.INFO, "JMSServerTransport activate().... ");
        try {
            LOG.log(Level.FINE, "establishing JMS connection");
            JMSProviderHub.connect(this, this.jmsDestinationConfigBean);
            this.listenerSession = this.sessionFactory.get(this.targetDestination);
            this.listenerThread = new JMSListenerThread(this.listenerSession, this);
            this.listenerThread.start();
        }
        catch (JMSException ex) {
            LOG.log(Level.FINE, "JMS connect failed with JMSException : ", ex);
            throw new IOException(ex.getMessage());
        }
        catch (NamingException nex) {
            LOG.log(Level.FINE, "JMS connect failed with NamingException : ", nex);
            throw new IOException(nex.getMessage());
        }
    }

    public void deactivate() throws IOException {
        try {
            this.listenerSession.consumer().close();
            if (this.listenerThread != null) {
                this.listenerThread.join();
            }
            this.sessionFactory.shutdown();
        }
        catch (InterruptedException e) {
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void shutdown() {
        LOG.log(Level.FINE, "JMSDestination shutdown()");
        try {
            this.deactivate();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Queue getReplyToDestination(org.apache.cxf.message.Message inMessage) throws JMSException, NamingException {
        Message message = (Message)inMessage.get((Object)"org.apache.cxf.jms.request.message");
        Queue replyTo = inMessage.get((Object)"org.apache.cxf.jms.server.replyto") != null ? this.sessionFactory.getQueueFromInitialContext((String)inMessage.get((Object)"org.apache.cxf.jms.server.replyto")) : (null != message.getJMSReplyTo() ? (Queue)message.getJMSReplyTo() : (Queue)this.replyDestination);
        return replyTo;
    }

    public void setReplyCorrelationID(Message request, Message reply) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID == null || "".equals(correlationID) && this.jmsDestinationConfigBean.getServer().isUseMessageIDAsCorrelationID()) {
            correlationID = request.getJMSMessageID();
        }
        if (correlationID != null && !"".equals(correlationID)) {
            reply.setJMSCorrelationID(correlationID);
        }
    }

    protected void incoming(Message message) throws IOException {
        try {
            LOG.log(Level.FINE, "server received request: ", message);
            String msgType = message instanceof TextMessage ? "text" : "binary";
            Object request = this.unmarshal(message, msgType);
            LOG.log(Level.FINE, "The Request Message is [ " + request + "]");
            byte[] bytes = null;
            if ("text".equals(msgType)) {
                String requestString = (String)request;
                LOG.log(Level.FINE, "server received request: ", requestString);
                bytes = requestString.getBytes();
            } else {
                bytes = (byte[])request;
            }
            MessageImpl inMessage = new MessageImpl();
            inMessage.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
            JMSMessageHeadersType headers = this.populateIncomingContext(message, (org.apache.cxf.message.Message)inMessage, "org.apache.cxf.jms.server.headers");
            inMessage.put((Object)"org.apache.cxf.jms.server.headers", (Object)headers);
            inMessage.put((Object)"org.apache.cxf.jms.request.message", (Object)message);
            inMessage.setDestination((Destination)this);
            this.incomingObserver.onMessage((org.apache.cxf.message.Message)inMessage);
        }
        catch (JMSException jmsex) {
            throw new IOException(jmsex.getMessage());
        }
    }

    private void initConfig() {
        final class JMSDestinationConfiguration
        extends JMSDestinationConfigBean {
            JMSDestinationConfiguration() {
            }

            public String getBeanName() {
                return JMSDestination.this.endpointInfo.getName().toString() + ".jms-destination";
            }
        }
        JMSDestinationConfiguration bean = new JMSDestinationConfiguration();
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean((Object)bean);
        }
        if (!bean.isSetServer()) {
            bean.setServer(new JMSServerBehaviorPolicyType());
        }
        if (!bean.isSetServerConfig()) {
            bean.setServerConfig(new JMSServerConfig());
        }
        ServiceModelJMSConfigurationProvider p = new ServiceModelJMSConfigurationProvider(this.endpointInfo);
        List<ServiceModelJMSConfigurationProvider> providers = this.getOverwriteProviders();
        if (null == providers) {
            providers = new ArrayList<ServiceModelJMSConfigurationProvider>();
        }
        providers.add(p);
        this.setOverwriteProviders(providers);
        providers = bean.getOverwriteProviders();
        if (null == providers) {
            providers = new ArrayList();
        }
        providers.add(p);
        bean.setOverwriteProviders(providers);
        this.jmsDestinationConfigBean = bean;
    }

    private class JMSOutputStream
    extends AbstractCachedOutputStream {
        private org.apache.cxf.message.Message inMessage;
        private JMSDestination jmsDestination;
        private Message reply;
        private Queue replyTo;
        private QueueSender sender;

        public JMSOutputStream(org.apache.cxf.message.Message m, JMSDestination d) {
            this.inMessage = m;
            this.jmsDestination = d;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void commitOutputMessage() throws IOException {
            headers = (JMSMessageHeadersType)this.inMessage.get((Object)"org.apache.cxf.jms.server.headers");
            request = (Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
            replySession = null;
            if (this.jmsDestination.isDestinationStyleQueue()) {
                try {
                    this.replyTo = JMSDestination.this.getReplyToDestination(this.inMessage);
                    replySession = JMSDestination.this.sessionFactory.get(false);
                    this.sender = (QueueSender)replySession.producer();
                    v0 = textPayload = request instanceof TextMessage != false;
                    if (textPayload) {
                        this.reply = JMSDestination.this.marshal(this.currentStream.toString(), replySession.session(), null, "text");
                        JMSDestination.LOG.log(Level.FINE, "The response message is [" + this.currentStream.toString() + "]");
                    } else {
                        this.reply = JMSDestination.this.marshal(((ByteArrayOutputStream)this.currentStream).toByteArray(), replySession.session(), null, "binary");
                        JMSDestination.LOG.log(Level.FINE, "The response message is [" + new String(((ByteArrayOutputStream)this.currentStream).toByteArray()) + "]");
                    }
                    JMSDestination.this.setReplyCorrelationID(request, this.reply);
                    JMSDestination.this.setMessageProperties(headers, this.reply);
                    this.sendResponse();
                    if (replySession == null) ** GOTO lbl34
                    JMSDestination.this.sessionFactory.recycle(replySession);
                }
                catch (JMSException ex) {
                    try {
                        JMSDestination.LOG.log(Level.WARNING, "Failed in post dispatch ...", ex);
                        throw new IOException(ex.getMessage());
                        catch (NamingException nex) {
                            JMSDestination.LOG.log(Level.WARNING, "Failed in post dispatch ...", nex);
                            throw new IOException(nex.getMessage());
                        }
                    }
                    catch (Throwable var5_7) {
                        if (replySession != null) {
                            JMSDestination.this.sessionFactory.recycle(replySession);
                        }
                        throw var5_7;
                    }
                }
            } else {
                JMSDestination.LOG.log(Level.WARNING, "discarding reply for non-oneway invocation ", "with 'topic' destinationStyle");
            }
lbl34:
            // 3 sources

            JMSDestination.LOG.log(Level.FINE, "just server sending reply: ", this.reply);
        }

        private void sendResponse() throws JMSException {
            JMSMessageHeadersType headers = (JMSMessageHeadersType)this.inMessage.get((Object)"org.apache.cxf.jms.server.headers");
            Message request = (Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
            int deliveryMode = JMSDestination.this.getJMSDeliveryMode(headers);
            int priority = JMSDestination.this.getJMSPriority(headers);
            long ttl = JMSDestination.this.getTimeToLive(headers);
            if (ttl <= 0L) {
                ttl = JMSDestination.this.jmsDestinationConfigBean.getServerConfig().getMessageTimeToLive();
            }
            long timeToLive = 0L;
            if (request.getJMSExpiration() > 0L) {
                SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
                GregorianCalendar cal = new GregorianCalendar(tz);
                timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
            }
            if (timeToLive >= 0L) {
                ttl = ttl > 0L ? ttl : timeToLive;
                LOG.log(Level.FINE, "send out the message!");
                this.sender.send(this.replyTo, this.reply, deliveryMode, priority, ttl);
            } else {
                LOG.log(Level.INFO, "Message time to live is already expired skipping response.");
            }
        }

        protected void doFlush() throws IOException {
        }

        protected void doClose() throws IOException {
            this.commitOutputMessage();
        }

        protected void onWrite() throws IOException {
        }
    }

    protected class BackChannelConduit
    implements Conduit {
        protected org.apache.cxf.message.Message inMessage;
        protected EndpointReferenceType target;
        protected JMSDestination jmsDestination;

        BackChannelConduit(EndpointReferenceType ref, org.apache.cxf.message.Message message, JMSDestination dest) {
            this.inMessage = message;
            this.target = ref;
            this.jmsDestination = dest;
        }

        public void close(org.apache.cxf.message.Message msg) throws IOException {
            ((OutputStream)msg.getContent(OutputStream.class)).close();
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void send(org.apache.cxf.message.Message message) throws IOException {
            message.put((Object)"org.apache.cxf.jms.request.message", this.inMessage.get((Object)"org.apache.cxf.jms.request.message"));
            message.setContent(OutputStream.class, (Object)new JMSOutputStream(this.inMessage, this.jmsDestination));
        }

        public EndpointReferenceType getTarget() {
            return this.target;
        }

        public Destination getBackChannel() {
            return null;
        }

        public void close() {
        }
    }

    static class JMSExecutor
    implements Runnable {
        Message message;
        JMSDestination jmsDestination;

        JMSExecutor(JMSDestination destionation, Message m) {
            this.message = m;
            this.jmsDestination = destionation;
        }

        public void run() {
            LOG.log(Level.INFO, "run the incoming message in the threadpool");
            try {
                this.jmsDestination.incoming(this.message);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Failed to process incoming message : ", ex);
            }
        }
    }

    class JMSListenerThread
    extends Thread {
        final JMSDestination jmsDestination;
        private final PooledSession listenSession;

        public JMSListenerThread(PooledSession session, JMSDestination destination) {
            this.listenSession = session;
            this.jmsDestination = destination;
        }

        public void run() {
            try {
                block7: while (true) {
                    Message message;
                    if ((message = this.listenSession.consumer().receive()) == null) {
                        LOG.log(Level.WARNING, "Null message received from message consumer.", " Exiting ListenerThread::run().");
                        return;
                    }
                    while (true) {
                        WorkQueueManager wqm;
                        if (message == null) continue block7;
                        Executor executor = null;
                        if (executor == null && null != (wqm = (WorkQueueManager)this.jmsDestination.bus.getExtension(WorkQueueManager.class))) {
                            executor = wqm.getAutomaticWorkQueue();
                        }
                        if (executor != null) {
                            try {
                                executor.execute(new JMSExecutor(this.jmsDestination, message));
                                message = null;
                            }
                            catch (RejectedExecutionException ree) {}
                        } else {
                            LOG.log(Level.INFO, "handle the incoming message in listener thread");
                            try {
                                this.jmsDestination.incoming(message);
                            }
                            catch (IOException ex) {
                                LOG.log(Level.WARNING, "Failed to process incoming message : ", ex);
                            }
                        }
                        message = null;
                    }
                    break;
                }
            }
            catch (JMSException jmsex) {
                jmsex.printStackTrace();
                LOG.log(Level.SEVERE, "Exiting ListenerThread::run(): ", jmsex.getMessage());
            }
            catch (Throwable jmsex) {
                jmsex.printStackTrace();
                LOG.log(Level.SEVERE, "Exiting ListenerThread::run(): ", jmsex.getMessage());
            }
        }
    }
}

