/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidatorUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(ValidatorUtil.class);

    private ValidatorUtil() {
    }

    public static List<XmlSchemaCollection> getSchemaList(Document document, String baseURI) throws IOException, SAXException {
        ArrayList<XmlSchemaCollection> schemaList = new ArrayList<XmlSchemaCollection>();
        if (document == null) {
            return schemaList;
        }
        XmlSchemaCollection schemaCol = new XmlSchemaCollection();
        NodeList nodes = document.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "schema");
        for (int x = 0; x < nodes.getLength(); ++x) {
            Node schemaNode = nodes.item(x);
            Element schemaEl = (Element)schemaNode;
            String tns = schemaEl.getAttribute("targetNamespace");
            try {
                schemaCol.read(schemaEl, tns);
                continue;
            }
            catch (RuntimeException ex) {
                schemaCol.read(schemaEl, baseURI);
            }
        }
        schemaList.add(schemaCol);
        Map<String, Document> wsdlImports = ValidatorUtil.getImportedWsdlMap(document, baseURI);
        for (Document wsdlImport : wsdlImports.values()) {
            schemaList.addAll(ValidatorUtil.getSchemaList(wsdlImport, baseURI));
        }
        return schemaList;
    }

    public static Map<String, Document> getImportedWsdlMap(Document document, String basePath) throws IOException, SAXException {
        HashMap<String, Document> docMap = new HashMap<String, Document>();
        if (document == null) {
            return docMap;
        }
        DocumentBuilder docBuilder = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ToolException((Throwable)e);
        }
        NodeList nodes = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        String myBasePath = basePath;
        try {
            myBasePath = new URI(basePath).getPath();
        }
        catch (URISyntaxException e1) {
            // empty catch block
        }
        for (int x = 0; x < nodes.getLength(); ++x) {
            String systemId;
            NamedNodeMap attributes = nodes.item(x).getAttributes();
            String namespace = attributes.getNamedItem("namespace").getNodeValue();
            if (docMap.containsKey(namespace)) continue;
            try {
                systemId = ValidatorUtil.getImportedUrl(attributes.getNamedItem("location").getNodeValue(), myBasePath);
            }
            catch (IOException ioe) {
                throw new ToolException((Throwable)ioe);
            }
            if (namespace == null || systemId == null) continue;
            Document docImport = docBuilder.parse(systemId);
            Node node = DOMUtils.getChild((Node)docImport, null);
            if (node != null && !"definitions".equals(node.getLocalName())) {
                Message msg = new Message("NOT_A_WSDLFILE", LOG, new Object[]{systemId});
                throw new ToolException(msg);
            }
            docMap.putAll(ValidatorUtil.getImportedWsdlMap(docImport, myBasePath));
            docMap.put(namespace, docImport);
        }
        return docMap;
    }

    private static String getImportedUrl(String theImportPath, String baseURI) throws IOException {
        File file = new File(theImportPath);
        if (file != null && file.exists()) {
            return file.toURL().toString();
        }
        File baseFile = new File(baseURI);
        file = new File(baseFile.getParent(), theImportPath);
        if (file != null && file.exists()) {
            return file.toURL().toString();
        }
        return null;
    }
}

