/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import org.apache.cxf.helpers.WSDLHelper;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.extensions.soap.SoapBody;
import org.apache.cxf.tools.common.extensions.soap.SoapHeader;
import org.apache.cxf.tools.util.SOAPBindingUtil;
import org.apache.cxf.tools.validator.internal.AbstractValidator;

public class WSIBPValidator
extends AbstractValidator {
    private List<String> operationMap = new ArrayList<String>();
    private WSDLHelper wsdlHelper = new WSDLHelper();

    public WSIBPValidator(Definition def) {
        super(def);
    }

    public boolean isValid() {
        for (Method m : this.getClass().getMethods()) {
            Boolean res = Boolean.TRUE;
            if (!m.getName().startsWith("check")) continue;
            try {
                res = (Boolean)m.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ToolException((Throwable)e);
            }
            if (res.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public boolean checkR2201() {
        for (PortType portType : this.wsdlHelper.getPortTypes(this.def)) {
            for (Operation operation : portType.getOperations()) {
                if (this.isOverloading(operation.getName())) continue;
                BindingOperation bop = this.wsdlHelper.getBindingOperation(this.def, operation.getName());
                Binding binding = this.wsdlHelper.getBinding(bop, this.def);
                String bindingStyle = binding != null ? SOAPBindingUtil.getBindingStyle((Binding)binding) : "";
                String style = "".equals(SOAPBindingUtil.getSOAPOperationStyle((BindingOperation)bop)) ? bindingStyle : SOAPBindingUtil.getSOAPOperationStyle((BindingOperation)bop);
                if (!"DOCUMENT".equalsIgnoreCase(style)) continue;
                List partsList = this.wsdlHelper.getInMessageParts(operation);
                int inmessagePartsCount = partsList.size();
                SoapBody soapBody = SOAPBindingUtil.getBindingInputSOAPBody((BindingOperation)bop);
                if (soapBody != null) {
                    List parts = soapBody.getParts();
                    int boundPartSize = parts == null ? inmessagePartsCount : parts.size();
                    SoapHeader soapHeader = SOAPBindingUtil.getBindingInputSOAPHeader((BindingOperation)bop);
                    int n = boundPartSize = soapHeader != null && soapHeader.getMessage().equals(operation.getInput().getMessage().getQName()) ? boundPartSize - 1 : boundPartSize;
                    if (parts != null) {
                        for (String partName : parts) {
                            boolean isDefined = false;
                            for (Part part : partsList) {
                                if (!partName.equalsIgnoreCase(part.getName())) continue;
                                isDefined = true;
                                break;
                            }
                            if (isDefined) continue;
                            this.addErrorMessage("operation: " + operation.getName() + " soapBody parts : " + partName + " not found in the message, wrong WSDL");
                            return false;
                        }
                    }
                    if (boundPartSize > 1) {
                        this.addErrorMessage("operation:" + operation.getName() + " more than one part bound to body");
                        return false;
                    }
                }
                int outmessagePartsCount = this.wsdlHelper.getOutMessageParts(operation).size();
                soapBody = SOAPBindingUtil.getBindingOutputSOAPBody((BindingOperation)bop);
                if (soapBody == null) continue;
                List parts = soapBody.getParts();
                int boundPartSize = parts == null ? outmessagePartsCount : parts.size();
                SoapHeader soapHeader = SOAPBindingUtil.getBindingOutputSOAPHeader((BindingOperation)bop);
                int n = boundPartSize = soapHeader != null && soapHeader.getMessage().equals(operation.getOutput().getMessage().getQName()) ? boundPartSize - 1 : boundPartSize;
                if (parts != null) {
                    for (String partName : parts) {
                        boolean isDefined = false;
                        for (Part part : this.wsdlHelper.getOutMessageParts(operation)) {
                            if (!partName.equalsIgnoreCase(part.getName())) continue;
                            isDefined = true;
                            break;
                        }
                        if (isDefined) continue;
                        this.addErrorMessage("operation: " + operation.getName() + " soapBody parts : " + partName + " not found in the message, wrong WSDL");
                        return false;
                    }
                }
                if (boundPartSize <= 1) continue;
                this.addErrorMessage("operation:" + operation.getName() + " more than one part bound to body");
                return false;
            }
        }
        return true;
    }

    public boolean checkR2203And2204() {
        for (Binding binding : this.def.getBindings().values()) {
            String style = SOAPBindingUtil.getCanonicalBindingStyle((Binding)binding);
            for (Operation operation : binding.getPortType().getOperations()) {
                if (operation.getInput() != null && operation.getInput().getMessage() != null) {
                    Message inMess = operation.getInput().getMessage();
                    for (Part p : inMess.getParts().values()) {
                        if (style.equalsIgnoreCase(SOAPBinding.Style.RPC.name()) && p.getTypeName() == null) {
                            this.addErrorMessage("An rpc-literal binding in a DESCRIPTION MUST refer, in its soapbind:body element(s), only to wsdl:part element(s) that have been defined using the type attribute.");
                            return false;
                        }
                        if (!style.equalsIgnoreCase(SOAPBinding.Style.DOCUMENT.name()) || p.getElementName() != null) continue;
                        this.addErrorMessage("A document-literal binding in a DESCRIPTION MUST refer, in each of its soapbind:body element(s),only to wsdl:part element(s) that have been defined using the element attribute.");
                        return false;
                    }
                }
                if (operation.getOutput() == null || operation.getOutput().getMessage() == null) continue;
                Message outMess = operation.getOutput().getMessage();
                for (Part p : outMess.getParts().values()) {
                    if (style.equalsIgnoreCase(SOAPBinding.Style.RPC.name()) && p.getTypeName() == null) {
                        this.addErrorMessage("An rpc-literal binding in a DESCRIPTION MUST refer, in its soapbind:body element(s), only to wsdl:part element(s) that have been defined using the type attribute.");
                        return false;
                    }
                    if (!style.equalsIgnoreCase(SOAPBinding.Style.DOCUMENT.name()) || p.getElementName() != null) continue;
                    this.addErrorMessage("A document-literal binding in a DESCRIPTION MUST refer, in each of its soapbind:body element(s),only to wsdl:part element(s) that have been defined using the element attribute.");
                    return false;
                }
            }
        }
        return true;
    }

    public boolean checkR2705() {
        for (Object obj : this.def.getBindings().values()) {
            Binding binding = (Binding)obj;
            if (!SOAPBindingUtil.isMixedStyle((Binding)binding)) continue;
            this.addErrorMessage("Mixed style, invalid WSDL");
            return false;
        }
        return true;
    }

    private boolean isOverloading(String operationName) {
        if (this.operationMap.contains(operationName)) {
            return true;
        }
        this.operationMap.add(operationName);
        return false;
    }
}

