/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormat;
import org.apache.cxf.tools.common.extensions.xmlformat.XMLFormatBinding;
import org.apache.cxf.tools.validator.internal.AbstractValidator;

public class XMLFormatValidator
extends AbstractValidator {
    public XMLFormatValidator(Definition def) {
        super(def);
    }

    public boolean isValid() {
        return this.checkXMLBindingFormat();
    }

    private boolean checkXMLBindingFormat() {
        Collection bindings = this.def.getBindings().values();
        if (bindings != null) {
            for (Binding binding : bindings) {
                Iterator it = binding.getExtensibilityElements().iterator();
                while (it.hasNext() && it.next() instanceof XMLFormatBinding) {
                    if (this.checkXMLFormat(binding)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkXMLFormat(Binding binding) {
        List bos = binding.getBindingOperations();
        boolean result = true;
        boolean needRootNode = false;
        for (BindingOperation bo : bos) {
            Operation op = binding.getPortType().getOperation(bo.getName(), null, null);
            needRootNode = false;
            if (op.getInput().getMessage().getParts().size() == 0 || op.getInput().getMessage().getParts().size() > 1) {
                needRootNode = true;
            }
            if (!needRootNode) continue;
            String path = "Binding(" + binding.getQName().getLocalPart() + "):BindingOperation(" + bo.getName() + ")";
            Iterator itIn = bo.getBindingInput().getExtensibilityElements().iterator();
            if (this.findXMLFormatRootNode(itIn, bo, path + "-input")) {
                needRootNode = false;
                if (op.getOutput().getMessage().getParts().size() == 0 || op.getOutput().getMessage().getParts().size() > 1) {
                    needRootNode = true;
                }
                if (!needRootNode) continue;
                Iterator itOut = bo.getBindingInput().getExtensibilityElements().iterator();
                if (result = result && this.findXMLFormatRootNode(itOut, bo, path + "-Output")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean findXMLFormatRootNode(Iterator it, BindingOperation bo, String errorPath) {
        while (it.hasNext()) {
            Object ext = it.next();
            if (!(ext instanceof XMLFormat)) continue;
            XMLFormat xmlFormat = (XMLFormat)ext;
            QName rootNodeName = new QName(this.def.getTargetNamespace(), bo.getName());
            if (xmlFormat.getRootNode() != null) {
                if (xmlFormat.getRootNode().equals(rootNodeName)) {
                    return true;
                }
                this.addErrorMessage(errorPath + ": wrong value of rootNode attribute, the value should be " + rootNodeName);
                return false;
            }
            this.addErrorMessage(errorPath + ": empty value of rootNode attribute, the value should be " + rootNodeName);
            return false;
        }
        this.addErrorMessage(errorPath + ": missing xml format body element");
        return false;
    }
}

