/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Collection;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.apache.cxf.attachment.AttachmentDataSource;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.CachedOutputStream;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.attachment.LazyAttachmentCollection;
import org.apache.cxf.attachment.MimeBodyPartInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;

public class AttachmentDeserializer {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHHOLD = 102400;
    private boolean lazyLoading = true;
    private PushbackInputStream stream;
    private String boundary;
    private String contentType;
    private LazyAttachmentCollection attachments;
    private Message message;
    private InputStream body;

    public AttachmentDeserializer(Message message) {
        this.message = message;
    }

    public void initializeAttachments() throws IOException {
        this.initializeRootMessage();
        this.attachments = new LazyAttachmentCollection(this);
        this.message.setAttachments((Collection)this.attachments);
    }

    protected void initializeRootMessage() throws IOException {
        this.contentType = (String)this.message.get((Object)"Content-Type");
        if (this.contentType == null) {
            throw new IllegalStateException("Content-Type can not be empty!");
        }
        InputStream input = (InputStream)this.message.getContent(InputStream.class);
        if (input == null) {
            throw new IllegalStateException("An InputStream must be provided!");
        }
        if (this.contentType.toLowerCase().indexOf("multipart/related") != -1) {
            int len;
            int end;
            int i = this.contentType.indexOf("boundary=\"");
            if (i == -1) {
                i = this.contentType.indexOf("boundary=");
                end = this.contentType.indexOf(";", i + 9);
                if (end == -1) {
                    end = this.contentType.length();
                }
                len = 9;
            } else {
                end = this.contentType.indexOf("\"", i + 10);
                len = 10;
            }
            if (i == -1 || end == -1) {
                throw new IOException("Invalid content type: missing boundary! " + this.contentType);
            }
            this.boundary = "--" + this.contentType.substring(i + len, end);
            this.stream = new PushbackInputStream(input, this.boundary.length());
            if (!AttachmentDeserializer.readTillFirstBoundary(this.stream, this.boundary.getBytes())) {
                throw new IOException("Couldn't find MIME boundary: " + this.boundary);
            }
            try {
                new InternetHeaders((InputStream)this.stream);
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            this.body = new DelegatingInputStream(new MimeBodyPartInputStream(this.stream, this.boundary.getBytes()));
            this.message.setContent(InputStream.class, (Object)this.body);
        }
    }

    public AttachmentImpl readNext() throws IOException {
        InternetHeaders headers;
        this.cacheStreamedAttachments();
        int v = this.stream.read();
        if (v == -1) {
            return null;
        }
        this.stream.unread(v);
        try {
            headers = new InternetHeaders((InputStream)this.stream);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        String id = headers.getHeader("Content-ID", null);
        if (id != null && id.startsWith("<")) {
            id = id.substring(1, id.length() - 1);
        }
        id = id.startsWith("cid:") ? id.substring(4) : id;
        AttachmentImpl att = new AttachmentImpl(id);
        this.setupAttachment(att, headers);
        return att;
    }

    private void cacheStreamedAttachments() throws IOException {
        if (this.body instanceof DelegatingInputStream && !((DelegatingInputStream)this.body).isClosed()) {
            this.cache((DelegatingInputStream)this.body, true);
            this.message.setContent(InputStream.class, (Object)this.body);
        }
        for (Attachment a : this.attachments.getLoadedAttachments()) {
            DataSource s = a.getDataHandler().getDataSource();
            this.cache((DelegatingInputStream)s.getInputStream(), false);
        }
    }

    private void cache(DelegatingInputStream input, boolean deleteOnClose) throws IOException {
        CachedOutputStream out = new CachedOutputStream();
        IOUtils.copy((InputStream)input, (OutputStream)((Object)out));
        input.setInputStream(out.getInputStream());
    }

    private static boolean readTillFirstBoundary(PushbackInputStream pbs, byte[] bp) throws IOException {
        int value = pbs.read();
        pbs.unread(value);
        while (value != -1) {
            int boundaryIndex;
            value = pbs.read();
            if ((byte)value != bp[0]) continue;
            for (boundaryIndex = 0; value != -1 && boundaryIndex < bp.length && (byte)value == bp[boundaryIndex]; ++boundaryIndex) {
                value = pbs.read();
                if (value != -1) continue;
                throw new IOException("Unexpected End while searching for first Mime Boundary");
            }
            if (boundaryIndex != bp.length) continue;
            pbs.read();
            return true;
        }
        return false;
    }

    private void setupAttachment(AttachmentImpl att, InternetHeaders headers) throws IOException {
        MimeBodyPartInputStream partStream = new MimeBodyPartInputStream(this.stream, this.boundary.getBytes());
        String ct = headers.getHeader("Content-Type", null);
        AttachmentDataSource source = new AttachmentDataSource(ct, new DelegatingInputStream(partStream));
        att.setDataHandler(new DataHandler((DataSource)source));
        Enumeration e = headers.getAllHeaders();
        while (e.hasMoreElements()) {
            Header header = (Header)e.nextElement();
            if (header.getName().equalsIgnoreCase("Content-Transfer-Encoding") && header.getValue().equalsIgnoreCase("binary")) {
                att.setXOP(true);
            }
            att.setHeader(header.getName(), header.getValue());
        }
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }
}

