/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding;

import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.extension.ExtensionManager;

public final class BindingFactoryManagerImpl
implements BindingFactoryManager {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(BindingFactoryManagerImpl.class);
    final Map<String, BindingFactory> bindingFactories = new ConcurrentHashMap<String, BindingFactory>();
    Properties factoryNamespaceMappings;
    ExtensionManager extensionManager;
    Bus bus;

    @Resource
    public void setExtensionManager(ExtensionManager em) {
        this.extensionManager = em;
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, BindingFactoryManager.class);
        }
    }

    BindingFactory loadBindingFactory(String className, String ... namespaceURIs) throws BusException {
        BindingFactory factory = null;
        try {
            Class<BindingFactory> clazz = Class.forName(className).asSubclass(BindingFactory.class);
            factory = clazz.newInstance();
            for (String namespace : namespaceURIs) {
                this.registerBindingFactory(namespace, factory);
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new BusException((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new BusException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new BusException((Throwable)iae);
        }
        return factory;
    }

    public void registerBindingFactory(String name, BindingFactory factory) {
        this.bindingFactories.put(name, factory);
    }

    public void unregisterBindingFactory(String name) {
        this.bindingFactories.remove(name);
    }

    public BindingFactory getBindingFactory(String namespace) throws BusException {
        BindingFactory factory = this.bindingFactories.get(namespace);
        if (null == factory) {
            this.extensionManager.activateViaNS(namespace);
            factory = this.bindingFactories.get(namespace);
        }
        if (null == factory) {
            throw new BusException(new Message("NO_BINDING_FACTORY_EXC", BUNDLE, new Object[]{namespace}));
        }
        return factory;
    }
}

