/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.extension.ExtensionManager;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class ExtensionManagerImpl
implements ExtensionManager,
BeanFactoryPostProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(ExtensionManagerImpl.class);
    private static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    private Map<String, Collection<String>> deferred = new HashMap<String, Collection<String>>();
    private ConfigurableListableBeanFactory factory;

    ExtensionManagerImpl() {
    }

    public void activateViaNS(String namespace) {
        Collection<String> beanNames = this.deferred.get(namespace);
        if (null != beanNames) {
            for (String n : beanNames) {
                try {
                    this.factory.getBean(n);
                }
                catch (BeansException ex) {
                    LogUtils.log((Logger)LOG, (Level)Level.WARNING, (String)"EXTENSION_ACTIVATION_EXC", (Throwable)ex, (Object)namespace);
                    throw ex;
                }
            }
            beanNames = null;
            this.deferred.remove(namespace);
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory f) throws BeansException {
        String[] names;
        this.factory = f;
        for (String n : names = this.factory.getBeanDefinitionNames()) {
            PropertyValue pv;
            MutablePropertyValues mpvs;
            BeanDefinition bd = this.factory.getBeanDefinition(n);
            if (!bd.isLazyInit() || null == (mpvs = bd.getPropertyValues()) || null == (pv = mpvs.getPropertyValue(ACTIVATION_NAMESPACES_PROPERTY_NAME))) continue;
            Collection activationNamespaces = null;
            try {
                Collection values = (Collection)pv.getValue();
                activationNamespaces = CastUtils.cast((Collection)values);
            }
            catch (ClassCastException ex) {
                ex.printStackTrace();
                continue;
            }
            for (String ns : activationNamespaces) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("registering bean " + n + " for deferred activation in namespace " + ns);
                }
                this.addDeferred(ns, n);
            }
        }
    }

    private void addDeferred(String namespace, String beanName) {
        Collection<String> beanNames = this.deferred.get(namespace);
        if (null == beanNames) {
            beanNames = new ArrayList<String>();
            this.deferred.put(namespace, beanNames);
        }
        beanNames.add(beanName);
    }
}

