/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.endpoint;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerRegistryImpl
implements ServerRegistry,
BusLifeCycleListener {
    List<Server> serversList = new ArrayList<Server>();
    Bus bus;
    BusLifeCycleManager lifeCycleManager;

    public Bus getBus() {
        return this.bus;
    }

    @Resource
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, ServerRegistry.class);
            this.lifeCycleManager = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class);
            if (null != this.lifeCycleManager) {
                this.lifeCycleManager.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    public void register(Server server) {
        this.serversList.add(server);
    }

    public void unregister(Server server) {
        this.serversList.remove(server);
    }

    public List<Server> getServers() {
        return this.serversList;
    }

    public void initComplete() {
    }

    @PreDestroy
    public void preShutdown() {
        for (Server server : this.serversList) {
            server.stop();
        }
    }

    public void postShutdown() {
    }
}

