/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.DataWriterFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutDatabindingInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractOutDatabindingInterceptor.class);

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }

    protected DataWriter getDataWriter(Message message, Class<?> output) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataWriterFactory factory = service.getDataBinding().getDataWriterFactory();
        this.setSchemaOutMessage(service, message);
        DataWriter dataWriter = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != output) continue;
            dataWriter = factory.createWriter(output);
            break;
        }
        if (dataWriter == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAWRITER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataWriter;
    }

    protected DataWriter<Message> getMessageDataWriter(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataWriterFactory factory = service.getDataBinding().getDataWriterFactory();
        this.setSchemaOutMessage(service, message);
        DataWriter dataWriter = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != Message.class) continue;
            dataWriter = factory.createWriter(Message.class);
            break;
        }
        if (dataWriter == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAWRITER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataWriter;
    }

    protected DataWriter<XMLStreamWriter> getDataWriter(Message message) {
        Service service = ServiceModelUtil.getService((Exchange)message.getExchange());
        DataWriterFactory factory = service.getDataBinding().getDataWriterFactory();
        this.setSchemaOutMessage(service, message);
        DataWriter dataWriter = null;
        for (Class cls : factory.getSupportedFormats()) {
            if (cls != XMLStreamWriter.class) continue;
            dataWriter = factory.createWriter(XMLStreamWriter.class);
            break;
        }
        if (dataWriter == null) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_DATAWRITER", BUNDLE, new Object[]{service.getName()}));
        }
        return dataWriter;
    }

    private void setSchemaOutMessage(Service service, Message message) {
        if (message.getContextualProperty(Message.SCHEMA_VALIDATION_ENABLED) != null && Boolean.TRUE.equals(message.getContextualProperty(Message.SCHEMA_VALIDATION_ENABLED))) {
            Schema schema = EndpointReferenceUtils.getSchema((ServiceInfo)service.getServiceInfo());
            service.getDataBinding().getDataWriterFactory().setSchema(schema);
        }
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
    }
}

