/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class BareInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(BareInInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(BareInInterceptor.class);
    private static Set<String> filter = new HashSet<String>();

    public BareInInterceptor() {
        this.setPhase("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.info("BareInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        Exchange exchange = message.getExchange();
        DataReader<Message> dr = this.getMessageDataReader(message);
        ArrayList<Object> parameters = new ArrayList<Object>();
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        Service service = ep.getService();
        BindingOperationInfo bop = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
        BindingMessageInfo msgInfo = null;
        boolean client = this.isRequestor(message);
        ArrayList<OperationInfo> ops = null;
        if (bop == null) {
            ops = new ArrayList<OperationInfo>();
            ops.addAll(service.getServiceInfo().getInterface().getOperations());
        } else if (msgInfo == null) {
            this.getMessageInfo(message, bop, exchange);
            msgInfo = client ? bop.getOutput() : bop.getInput();
        }
        int paramNum = 0;
        while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            MessagePartInfo p;
            QName elName = xmlReader.getName();
            Object o = null;
            if (msgInfo != null && msgInfo.getMessageParts() != null) {
                assert (msgInfo.getMessageParts().size() > paramNum);
                p = (MessagePartInfo)msgInfo.getMessageParts().get(paramNum);
            } else {
                p = this.findMessagePart(exchange, ops, elName, client, paramNum);
            }
            if (p == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", BUNDLE, new Object[]{elName}));
            }
            o = dr.read(p, (Object)message);
            if (o != null) {
                parameters.add(o);
            }
            ++paramNum;
        }
        message.setContent(List.class, parameters);
    }

    static {
        filter.add("void");
        filter.add("javax.activation.DataHandler");
    }
}

