/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.AbstractCachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingOutInterceptor
extends AbstractPhaseInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(LoggingOutInterceptor.class);
    private Set<String> before = Collections.singleton(StaxOutInterceptor.class.getName());

    public LoggingOutInterceptor() {
        this.setPhase("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        OutputStream os = (OutputStream)message.getContent(OutputStream.class);
        if (os == null) {
            return;
        }
        if (os instanceof AbstractCachedOutputStream) {
            ((AbstractCachedOutputStream)os).registerCallback((CachedOutputStreamCallback)new LoggingCallback());
        }
    }

    public Set<String> getBefore() {
        return this.before;
    }

    class LoggingCallback
    implements CachedOutputStreamCallback {
        private boolean flushed;

        LoggingCallback() {
        }

        public void onFlush(AbstractCachedOutputStream cos) {
            if (!this.flushed) {
                OutputStream os = cos.getOut();
                if (os instanceof ByteArrayOutputStream) {
                    ByteArrayOutputStream bos = (ByteArrayOutputStream)os;
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info("Outbound message: " + bos.toString());
                    }
                }
                this.flushed = true;
            }
        }

        public void onClose(AbstractCachedOutputStream cos) {
        }
    }
}

