/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.cxf.attachment.AttachmentDeserializer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartMessageInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String ATTACHMENT_DIRECTORY = "attachment-directory";
    public static final String ATTACHMENT_MEMORY_THRESHOLD = "attachment-memory-threshold";
    public static final int THRESHHOLD = 102400;
    private static final Logger LOG = Logger.getLogger(MultipartMessageInterceptor.class.getName());

    public MultipartMessageInterceptor() {
        this.setPhase("receive");
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("MultipartMessageInterceptor skipped in HTTP GET method");
            return;
        }
        if (!Boolean.TRUE.equals(message.getContextualProperty("mtom-enabled"))) {
            return;
        }
        AttachmentDeserializer ad = new AttachmentDeserializer(message);
        try {
            ad.initializeAttachments();
        }
        catch (IOException e) {
            throw new Fault((Throwable)e);
        }
    }

    public void handleFault(Message messageParam) {
    }
}

