/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.util.CollectionUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.MethodDispatcher;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIMappingInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(URIMappingInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(URIMappingInterceptor.class);

    public URIMappingInterceptor() {
        this.setPhase("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get((Object)Message.HTTP_REQUEST_METHOD);
        LOG.info("Invoking HTTP method " + method);
        if (!this.isGET(message)) {
            LOG.info("URIMappingInterceptor can only handle HTTP GET, not HTTP " + method);
            return;
        }
        String opName = this.getOperationName(message);
        LOG.info("URIMappingInterceptor get operation: " + opName);
        BindingOperationInfo op = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (String)opName);
        if (op == null || opName == null || op.getName() == null || StringUtils.isEmpty((String)op.getName().getLocalPart()) || !opName.equals(op.getName().getLocalPart())) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION", BUNDLE, new Object[]{opName}));
        }
        message.getExchange().put(BindingOperationInfo.class, (Object)op);
        message.setContent(List.class, this.getParameters(message, op));
    }

    private Method getMethod(Message message, BindingOperationInfo operation) {
        MethodDispatcher md = (MethodDispatcher)((Service)message.getExchange().get(Service.class)).get((Object)MethodDispatcher.class.getName());
        return md.getMethod(operation);
    }

    private boolean isFixedParameterOrder(Message message) {
        Boolean order = (Boolean)message.get((Object)Message.FIXED_PARAMETER_ORDER);
        return order != null && order != false;
    }

    protected Map<String, String> keepInOrder(Map<String, String> params, OperationInfo operation, List<String> order) {
        if (params == null || params.size() == 0) {
            return params;
        }
        if (order == null || order.size() == 0) {
            return params;
        }
        LinkedHashMap<String, String> orderedParameters = new LinkedHashMap<String, String>();
        for (String name : order) {
            orderedParameters.put(name, params.get(name));
        }
        if (order.size() != params.size()) {
            LOG.info(order.size() + " parameters definded in WSDL but found " + params.size() + " in request!");
            Collection rest = CollectionUtils.diff(order, params.keySet());
            if (rest != null && rest.size() > 0) {
                LOG.info("Set the following parameters to null: " + rest);
                for (String key : rest) {
                    orderedParameters.put(key, null);
                }
            }
        }
        return orderedParameters;
    }

    protected List<Object> getParameters(Message message, BindingOperationInfo operation) {
        ArrayList<Object> parameters = new ArrayList<Object>();
        int idx = parameters.size();
        Map<String, String> queries = this.getQueries(message);
        if (!this.isFixedParameterOrder(message)) {
            boolean emptyQueries = CollectionUtils.isEmpty(queries.values());
            List names = ServiceModelUtil.getOperationInputPartNames((OperationInfo)operation.getOperationInfo());
            queries = this.keepInOrder(queries, operation.getOperationInfo(), names);
            if (!emptyQueries && CollectionUtils.isEmpty(queries.values())) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("ORDERED_PARAM_REQUIRED", BUNDLE, new Object[]{names.toString()}));
            }
        }
        Method method = this.getMethod(message, operation);
        Class<?>[] types = method.getParameterTypes();
        for (String key : queries.keySet()) {
            Class<?> type = types[idx];
            if (type == null) {
                LOG.warning("URIMappingInterceptor MessagePartInfo NULL ");
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_PART_FOUND", BUNDLE, new Object[]{"index: " + idx + " on key " + key}));
            }
            Object param = null;
            param = type != null && type.isPrimitive() && queries.get(key) != null ? PrimitiveUtils.read((String)queries.get(key), type) : queries.get(key);
            parameters.add(param);
            idx = parameters.size();
        }
        return parameters;
    }

    private String uriDecode(String query) {
        try {
            query = URLDecoder.decode(query, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.warning(query + " can not be decoded: " + e.getMessage());
        }
        return query;
    }

    protected Map<String, String> getQueries(Message message) {
        LinkedHashMap<String, String> queries = new LinkedHashMap<String, String>();
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!StringUtils.isEmpty((String)query)) {
            List<String> parts = Arrays.asList(query.split("&"));
            for (String part : parts) {
                String[] keyValue = part.split("=");
                queries.put(keyValue[0], this.uriDecode(keyValue[1]));
            }
            return queries;
        }
        String rest = this.getRest(message);
        List parts = StringUtils.getParts((String)rest, (String)"/");
        for (int i = 1; i < parts.size(); i += 2) {
            if (i + 1 > parts.size()) {
                queries.put((String)parts.get(i), (String)null);
                continue;
            }
            queries.put((String)parts.get(i), this.uriDecode((String)parts.get(i + 1)));
        }
        return queries;
    }

    private String getBasePath(Message message) {
        return (String)message.get((Object)Message.BASE_PATH);
    }

    private String getRest(Message message) {
        String path = (String)message.get((Object)Message.PATH_INFO);
        String basePath = this.getBasePath(message);
        return StringUtils.diff((String)path, (String)basePath);
    }

    protected String getOperationName(Message message) {
        String rest = this.getRest(message);
        String opName = StringUtils.getFirstNotEmpty((String)rest, (String)"/");
        if (opName.indexOf("?") != -1) {
            opName = opName.split("\\?")[0];
        }
        return opName;
    }
}

