/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class WrappedInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(WrappedInInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(WrappedInInterceptor.class);

    public WrappedInInterceptor() {
        this.setPhase("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    public void handleMessage(Message message) {
        ArrayList<Object> objects;
        if (this.isGET(message) && message.getContent(List.class) != null) {
            LOG.info("WrappedInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            return;
        }
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        boolean requestor = this.isRequestor(message);
        if (operation == null) {
            String local = xmlReader.getLocalName();
            if (requestor && local.endsWith("Response")) {
                local = local.substring(0, local.length() - 8);
            }
            if ((operation = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (String)local)) == null) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_OPERATION", BUNDLE, new Object[]{local}));
            }
        }
        DataReader<Message> dr = this.getMessageDataReader(message);
        MessageInfo msgInfo = this.setMessage(message, operation, requestor);
        if (operation.isUnwrappedCapable() && ((MessagePartInfo)msgInfo.getMessageParts().get(0)).getTypeClass() != null) {
            objects = new ArrayList();
            Object wrappedObject = dr.read((MessagePartInfo)msgInfo.getMessageParts().get(0), (Object)message);
            objects.add(wrappedObject);
        } else {
            objects = new ArrayList<Object>();
            if (operation.isUnwrappedCapable()) {
                operation = operation.getUnwrappedOperation();
            }
            msgInfo = this.setMessage(message, operation, requestor);
            List messageParts = msgInfo.getMessageParts();
            Iterator itr = messageParts.iterator();
            if (xmlReader.getEventType() == 1) {
                StaxUtils.nextEvent((XMLStreamReader)xmlReader);
            }
            while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
                MessagePartInfo part = (MessagePartInfo)itr.next();
                objects.add(dr.read(part, (Object)message));
            }
        }
        message.setContent(List.class, objects);
    }

    private MessageInfo setMessage(Message message, BindingOperationInfo operation, boolean requestor) {
        MessageInfo msgInfo = this.getMessageInfo(message, operation, requestor);
        message.put(MessageInfo.class, (Object)msgInfo);
        message.getExchange().put(BindingOperationInfo.class, (Object)operation);
        message.getExchange().put(OperationInfo.class, (Object)operation.getOperationInfo());
        message.getExchange().setOneWay(operation.getOperationInfo().isOneWay());
        return msgInfo;
    }
}

