/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.TypeInfo;
import org.apache.cxf.wsdl11.SchemaSerializer;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceWSDLBuilder {
    private static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private Map<String, String> prefix2ns;
    private Map<String, String> ns2prefix;
    private Definition definition;
    private ServiceInfo service;

    public ServiceWSDLBuilder(ServiceInfo service) {
        this.service = service;
        this.prefix2ns = new HashMap<String, String>();
        this.ns2prefix = new HashMap<String, String>();
    }

    public Definition build() throws WSDLException {
        try {
            this.definition = (Definition)this.service.getProperty(WSDLServiceBuilder.WSDL_DEFINITION, Definition.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (this.definition == null) {
            this.definition = WSDLFactory.newInstance().newDefinition();
            this.definition.getExtensionRegistry().registerSerializer(Types.class, SCHEMA_QNAME, (ExtensionSerializer)new SchemaSerializer());
            this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
            this.addNamespace("soap", "http://schemas.xmlsoap.org/soap/");
            this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            this.definition.setQName(this.service.getName());
            this.definition.setTargetNamespace(this.service.getTargetNamespace());
            this.addExtensibiltyElements((ElementExtensible)this.definition, this.getWSDL11Extensors((AbstractPropertiesHolder)this.service));
            if (this.service.getTypeInfo() != null) {
                this.buildTypes(this.service.getTypeInfo());
            }
            this.buildPortType(this.service.getInterface());
            this.buildBinding(this.service.getBindings());
            this.buildService(this.service);
        }
        return this.definition;
    }

    public List<ExtensibilityElement> getWSDL11Extensors(AbstractPropertiesHolder holder) {
        return holder.getExtensors(ExtensibilityElement.class);
    }

    protected void addExtensibiltyElements(ElementExtensible elementExtensible, List<ExtensibilityElement> extensibilityElements) {
        if (extensibilityElements != null) {
            for (ExtensibilityElement element : extensibilityElements) {
                elementExtensible.addExtensibilityElement(element);
            }
        }
    }

    protected void buildTypes(TypeInfo typeInfo) {
        Types types = this.definition.createTypes();
        for (SchemaInfo schemaInfo : typeInfo.getSchemas()) {
            SchemaImpl schemaImpl = new SchemaImpl();
            schemaImpl.setRequired(Boolean.valueOf(true));
            schemaImpl.setElementType(SCHEMA_QNAME);
            schemaImpl.setElement(schemaInfo.getElement());
            types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
        }
        this.definition.setTypes(types);
    }

    protected void buildBinding(Collection<BindingInfo> bindingInfos) {
        Binding binding = null;
        for (BindingInfo bindingInfo : bindingInfos) {
            binding = this.definition.createBinding();
            binding.setUndefined(false);
            for (PortType portType : CastUtils.cast(this.definition.getPortTypes().values(), PortType.class)) {
                if (!portType.getQName().equals(bindingInfo.getInterface().getName())) continue;
                binding.setPortType(portType);
                break;
            }
            binding.setQName(bindingInfo.getName());
            this.buildBindingOperation(this.definition, binding, bindingInfo.getOperations());
            this.addExtensibiltyElements((ElementExtensible)binding, this.getWSDL11Extensors((AbstractPropertiesHolder)bindingInfo));
            this.definition.addBinding(binding);
        }
    }

    protected void buildBindingOperation(Definition def, Binding binding, Collection<BindingOperationInfo> bindingOperationInfos) {
        BindingOperation bindingOperation = null;
        for (BindingOperationInfo bindingOperationInfo : bindingOperationInfos) {
            bindingOperation = def.createBindingOperation();
            bindingOperation.setName(bindingOperationInfo.getName().getLocalPart());
            for (Operation operation : CastUtils.cast((List)binding.getPortType().getOperations(), Operation.class)) {
                if (!operation.getName().equals(bindingOperation.getName())) continue;
                bindingOperation.setOperation(operation);
                break;
            }
            this.buildBindingInput(def, bindingOperation, bindingOperationInfo.getInput());
            this.buildBindingOutput(def, bindingOperation, bindingOperationInfo.getOutput());
            this.buildBindingFault(def, bindingOperation, bindingOperationInfo.getFaults());
            this.addExtensibiltyElements((ElementExtensible)bindingOperation, this.getWSDL11Extensors((AbstractPropertiesHolder)bindingOperationInfo));
            binding.addBindingOperation(bindingOperation);
        }
    }

    protected void buildBindingFault(Definition def, BindingOperation bindingOperation, Collection<BindingFaultInfo> bindingFaultInfos) {
        BindingFault bindingFault = null;
        for (BindingFaultInfo bindingFaultInfo : bindingFaultInfos) {
            bindingFault = def.createBindingFault();
            bindingFault.setName(bindingFaultInfo.getFaultInfo().getFaultName().getLocalPart());
            bindingOperation.addBindingFault(bindingFault);
            this.addExtensibiltyElements((ElementExtensible)bindingFault, this.getWSDL11Extensors((AbstractPropertiesHolder)bindingFaultInfo));
        }
    }

    protected void buildBindingInput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingInput bindingInput = null;
        if (bindingMessageInfo != null) {
            bindingInput = def.createBindingInput();
            bindingInput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingInput(bindingInput);
            this.addExtensibiltyElements((ElementExtensible)bindingInput, this.getWSDL11Extensors((AbstractPropertiesHolder)bindingMessageInfo));
        }
    }

    protected void buildBindingOutput(Definition def, BindingOperation bindingOperation, BindingMessageInfo bindingMessageInfo) {
        BindingOutput bindingOutput = null;
        if (bindingMessageInfo != null) {
            bindingOutput = def.createBindingOutput();
            bindingOutput.setName(bindingMessageInfo.getMessageInfo().getName().getLocalPart());
            bindingOperation.setBindingOutput(bindingOutput);
            this.addExtensibiltyElements((ElementExtensible)bindingOutput, this.getWSDL11Extensors((AbstractPropertiesHolder)bindingMessageInfo));
        }
    }

    protected void buildService(ServiceInfo serviceInfo) {
        Service serv = this.definition.createService();
        serv.setQName(serviceInfo.getName());
        this.addNamespace(serviceInfo.getName().getNamespaceURI());
        this.definition.addService(serv);
        for (EndpointInfo ei : serviceInfo.getEndpoints()) {
            this.addNamespace(ei.getTransportId());
            this.addNamespace(ei.getBinding().getBindingId());
            Port port = this.definition.createPort();
            port.setName(ei.getName().getLocalPart());
            port.setBinding(this.definition.getBinding(ei.getBinding().getName()));
            this.addExtensibiltyElements((ElementExtensible)port, this.getWSDL11Extensors((AbstractPropertiesHolder)ei));
            serv.addPort(port);
        }
    }

    protected void buildPortType(InterfaceInfo intf) {
        PortType portType = null;
        try {
            portType = (PortType)intf.getProperty(WSDLServiceBuilder.WSDL_PORTTYPE, PortType.class);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (portType == null) {
            portType = this.definition.createPortType();
            portType.setQName(intf.getName());
            this.addNamespace(intf.getName().getNamespaceURI());
            portType.setUndefined(false);
            this.buildPortTypeOperation(portType, intf.getOperations());
        }
        this.definition.addPortType(portType);
    }

    protected void addNamespace(String namespaceURI) {
        this.addNamespace(this.getPrefix(namespaceURI), namespaceURI);
    }

    protected void addNamespace(String prefix, String namespaceURI) {
        this.prefix2ns.put(prefix, namespaceURI);
        this.ns2prefix.put(namespaceURI, prefix);
        this.definition.addNamespace(prefix, namespaceURI);
    }

    protected void buildPortTypeOperation(PortType portType, Collection<OperationInfo> operationInfos) {
        for (OperationInfo operationInfo : operationInfos) {
            Operation operation = null;
            try {
                operation = (Operation)operationInfo.getProperty(WSDLServiceBuilder.WSDL_OPERATION, Operation.class);
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            if (operation == null) {
                operation = this.definition.createOperation();
                operation.setUndefined(false);
                operation.setName(operationInfo.getName().getLocalPart());
                this.addNamespace(operationInfo.getName().getNamespaceURI());
                if (operationInfo.isOneWay()) {
                    operation.setStyle(OperationType.ONE_WAY);
                }
                Input input = this.definition.createInput();
                input.setName(operationInfo.getInputName());
                Message message = this.definition.createMessage();
                this.buildMessage(message, (AbstractMessageContainer)operationInfo.getInput());
                input.setMessage(message);
                operation.setInput(input);
                Output output = this.definition.createOutput();
                output.setName(operationInfo.getOutputName());
                message = this.definition.createMessage();
                this.buildMessage(message, (AbstractMessageContainer)operationInfo.getOutput());
                output.setMessage(message);
                operation.setOutput(output);
                Collection faults = operationInfo.getFaults();
                Fault fault = null;
                for (FaultInfo faultInfo : faults) {
                    fault = this.definition.createFault();
                    fault.setName(faultInfo.getFaultName().getLocalPart());
                    message = this.definition.createMessage();
                    this.buildMessage(message, (AbstractMessageContainer)faultInfo);
                    fault.setMessage(message);
                    operation.addFault(fault);
                }
            }
            portType.addOperation(operation);
        }
    }

    protected String getPrefix(String ns) {
        String prefix = this.ns2prefix.get(ns);
        if (prefix == null) {
            prefix = this.getNewPrefix();
            this.ns2prefix.put(ns, prefix);
        }
        return prefix;
    }

    protected String getNewPrefix() {
        String prefix = "ns1";
        int i = 0;
        while (this.prefix2ns.get(prefix) != null) {
            prefix = "ns" + ++i;
        }
        return prefix;
    }

    protected void buildMessage(Message message, AbstractMessageContainer messageContainer) {
        message.setQName(messageContainer.getName());
        message.setUndefined(false);
        this.definition.addMessage(message);
        List messageParts = messageContainer.getMessageParts();
        Part messagePart = null;
        for (MessagePartInfo messagePartInfo : messageParts) {
            messagePart = this.definition.createPart();
            messagePart.setName(messagePartInfo.getName().getLocalPart());
            if (messagePartInfo.isElement()) {
                messagePart.setElementName(messagePartInfo.getElementQName());
                this.addNamespace(messagePartInfo.getElementQName().getNamespaceURI());
            } else if (messagePartInfo.getTypeQName() != null) {
                messagePart.setTypeName(messagePartInfo.getTypeQName());
                this.addNamespace(messagePartInfo.getTypeQName().getNamespaceURI());
            }
            message.addPart(messagePart);
        }
    }
}

