/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl11;

import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.bind.JAXBException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertiesLoaderUtils;
import org.apache.cxf.wsdl.JAXBExtensionHelper;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl4jutils.WSDLLocatorImpl;
import org.w3c.dom.Element;

public class WSDLManagerImpl
implements WSDLManager {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLManagerImpl.class);
    private static final String EXTENSIONS_RESOURCE = "META-INF/extensions.xml";
    final ExtensionRegistry registry;
    final WSDLFactory factory;
    final WeakHashMap<Object, Definition> definitionsMap;
    private Bus bus;

    public WSDLManagerImpl() throws BusException {
        try {
            this.factory = WSDLFactory.newInstance();
            this.registry = this.factory.newPopulatedExtensionRegistry();
        }
        catch (WSDLException e) {
            throw new BusException((Throwable)e);
        }
        this.definitionsMap = new WeakHashMap();
        this.registerInitialExtensions();
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, WSDLManager.class);
        }
    }

    public WSDLFactory getWSDLFactory() {
        return this.factory;
    }

    public ExtensionRegistry getExtenstionRegistry() {
        return this.registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(URL url) throws WSDLException {
        WeakHashMap<Object, Definition> weakHashMap = this.definitionsMap;
        synchronized (weakHashMap) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        Definition def = this.loadDefinition(url.toString());
        WeakHashMap<Object, Definition> weakHashMap2 = this.definitionsMap;
        synchronized (weakHashMap2) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(String url) throws WSDLException {
        WeakHashMap<Object, Definition> weakHashMap = this.definitionsMap;
        synchronized (weakHashMap) {
            if (this.definitionsMap.containsKey(url)) {
                return this.definitionsMap.get(url);
            }
        }
        return this.loadDefinition(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition(Element el) throws WSDLException {
        WeakHashMap<Object, Definition> weakHashMap = this.definitionsMap;
        synchronized (weakHashMap) {
            if (this.definitionsMap.containsKey(el)) {
                return this.definitionsMap.get(el);
            }
        }
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.registry);
        Definition def = reader.readWSDL("", el);
        WeakHashMap<Object, Definition> weakHashMap2 = this.definitionsMap;
        synchronized (weakHashMap2) {
            this.definitionsMap.put(el, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefinition(Object key, Definition wsdl) {
        WeakHashMap<Object, Definition> weakHashMap = this.definitionsMap;
        synchronized (weakHashMap) {
            this.definitionsMap.put(key, wsdl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Definition loadDefinition(String url) throws WSDLException {
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.registry);
        WSDLLocatorImpl wsdlLocator = new WSDLLocatorImpl(url);
        Definition def = reader.readWSDL((WSDLLocator)wsdlLocator);
        WeakHashMap<Object, Definition> weakHashMap = this.definitionsMap;
        synchronized (weakHashMap) {
            this.definitionsMap.put(url, def);
        }
        return def;
    }

    private void registerInitialExtensions() throws BusException {
        Properties initialExtensions = null;
        try {
            initialExtensions = PropertiesLoaderUtils.loadAllProperties((String)EXTENSIONS_RESOURCE, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (IOException ex) {
            throw new BusException((Throwable)ex);
        }
        Iterator<Object> it = initialExtensions.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer st = new StringTokenizer(initialExtensions.getProperty((String)it.next()), "=");
            String parentType = st.nextToken();
            String elementType = st.nextToken();
            try {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Registering extension: " + elementType + " for parent: " + parentType);
                }
                JAXBExtensionHelper.addExtensions((ExtensionRegistry)this.registry, (String)parentType, (String)elementType, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
            catch (JAXBException ex) {
                LOG.log(Level.WARNING, "EXTENSION_ADD_FAILED_MSG", ex);
            }
        }
    }
}

