/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxws.AsyncCallbackFuture;
import org.apache.cxf.jaxws.AsyncResponse;
import org.apache.cxf.jaxws.BindingProviderImpl;
import org.apache.cxf.jaxws.DispatchAsyncCallable;
import org.apache.cxf.jaxws.interceptors.DispatchInInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutInterceptor;
import org.apache.cxf.jaxws.support.ContextPropertiesMapping;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatchImpl<T>
extends BindingProviderImpl
implements Dispatch<T>,
MessageObserver {
    private static final Logger LOG = LogUtils.getL7dLogger(DispatchImpl.class);
    private Bus bus;
    private Class<T> cl;
    private Executor executor;
    private JAXBContext context;
    private Service.Mode mode;
    private Endpoint endpoint;

    DispatchImpl(Bus b, Service.Mode m, Class<T> clazz, Executor e, Endpoint ep) {
        this.bus = b;
        this.cl = clazz;
        this.executor = e;
        this.mode = m;
        this.endpoint = ep;
        this.setupEndpointAddressContext();
    }

    DispatchImpl(Bus b, Service.Mode m, JAXBContext ctx, Class<T> clazz, Executor e, Endpoint ep) {
        this.bus = b;
        this.executor = e;
        this.context = ctx;
        this.cl = clazz;
        this.mode = m;
        this.endpoint = ep;
        this.setupEndpointAddressContext();
    }

    private void setupEndpointAddressContext() {
        if (null != this.endpoint && null != this.endpoint.getEndpointInfo().getAddress()) {
            Map<String, Object> requestContext = this.getRequestContext();
            requestContext.put("javax.xml.ws.service.endpoint.address", this.endpoint.getEndpointInfo().getAddress());
        }
    }

    public T invoke(T obj) {
        return this.invoke(obj, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invoke(T obj, boolean isOneWay) {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Dispatch: invoke called");
        }
        Message message = this.endpoint.getBinding().createMessage();
        if (this.context != null) {
            message.setContent(JAXBContext.class, (Object)this.context);
        }
        Map<String, Object> requestContext = this.getRequestContext();
        Map<String, Object> responseContext = this.getResponseContext();
        message.putAll(requestContext);
        ContextPropertiesMapping.mapRequestfromJaxws2Cxf((Map<String, Object>)message);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.put(Service.Mode.class, (Object)this.mode);
        exchange.put(Class.class, this.cl);
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.setOutMessage(message);
        message.setExchange((Exchange)exchange);
        message.setContent(Object.class, obj);
        PhaseInterceptorChain chain = this.getDispatchOutChain();
        message.setInterceptorChain((InterceptorChain)chain);
        Conduit conduit = this.getConduit();
        exchange.setConduit(conduit);
        conduit.setMessageObserver((MessageObserver)this);
        chain.doIntercept(message);
        if (message.getContent(Exception.class) != null) {
            throw new RuntimeException((Throwable)message.get(Exception.class));
        }
        if (conduit.getBackChannel() != null) {
            // empty if block
        }
        if (!isOneWay) {
            ExchangeImpl exchangeImpl = exchange;
            synchronized (exchangeImpl) {
                Message inMsg = this.waitResponse((Exchange)exchange);
                responseContext.putAll((Map<String, Object>)inMsg);
                ContextPropertiesMapping.mapResponsefromCxf2Jaxws(responseContext);
                return this.cl.cast(inMsg.getContent(Object.class));
            }
        }
        return null;
    }

    private Message waitResponse(Exchange exchange) {
        Message inMsg = exchange.getInMessage();
        if (inMsg == null) {
            try {
                exchange.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            inMsg = exchange.getInMessage();
        }
        if (inMsg.getContent(Exception.class) != null) {
            throw new RuntimeException((Throwable)inMsg.getContent(Exception.class));
        }
        return inMsg;
    }

    private PhaseInterceptorChain getDispatchOutChain() {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getOutPhases());
        List il = this.bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        il = this.endpoint.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(il);
        ArrayList<DispatchOutInterceptor> outInterceptors = new ArrayList<DispatchOutInterceptor>();
        outInterceptors.add(new DispatchOutInterceptor());
        chain.add(outInterceptors);
        return chain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        message = this.endpoint.getBinding().createMessage(message);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(pm.getInPhases());
        message.setInterceptorChain((InterceptorChain)chain);
        List il = this.bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add(il);
        this.endpoint.getInInterceptors().clear();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add(this.endpoint.getInInterceptors());
        ArrayList<DispatchInInterceptor> inInterceptors = new ArrayList<DispatchInInterceptor>();
        inInterceptors.add(new DispatchInInterceptor());
        chain.add(inInterceptors);
        try {
            chain.doIntercept(message);
        }
        finally {
            Exchange exchange = message.getExchange();
            synchronized (exchange) {
                message.getExchange().setInMessage(message);
                message.getExchange().notifyAll();
            }
        }
    }

    private Conduit getConduit() {
        EndpointInfo ei = this.endpoint.getEndpointInfo();
        String transportID = ei.getTransportId();
        try {
            ConduitInitiator ci = ((ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiator(transportID);
            return ci.getConduit(ei);
        }
        catch (BusException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private Executor getExecutor() {
        if (this.executor == null) {
            this.executor = this.endpoint.getService().getExecutor();
        }
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(5);
        }
        if (this.executor == null) {
            System.err.println("Can't not get executor");
        }
        return this.executor;
    }

    public Future<?> invokeAsync(T obj, AsyncHandler<T> asyncHandler) {
        Response<T> r = this.invokeAsync(obj);
        AsyncCallbackFuture callback = new AsyncCallbackFuture(r, asyncHandler);
        this.getExecutor().execute(callback);
        return callback;
    }

    public Response<T> invokeAsync(T obj) {
        FutureTask<T> f = new FutureTask<T>(new DispatchAsyncCallable<T>(this, obj));
        this.getExecutor().execute(f);
        return new AsyncResponse<T>(f, this.cl);
    }

    public void invokeOneWay(T obj) {
        this.invoke(obj, true);
    }
}

