/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxws.interceptors.DispatchInInterceptor;
import org.apache.cxf.jaxws.interceptors.DispatchOutInterceptor;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.transport.MessageObserver;

public class ProviderChainObserver
implements MessageObserver {
    Endpoint endpoint;
    Bus bus;
    JaxWsImplementorInfo implInfo;

    public ProviderChainObserver(Endpoint endpoint, Bus bus, JaxWsImplementorInfo implInfo) {
        this.endpoint = endpoint;
        this.bus = bus;
        this.implInfo = implInfo;
    }

    public void onMessage(Message m) {
        Message message = this.endpoint.getBinding().createMessage(m);
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setInMessage(message);
        message.setExchange((Exchange)exchange);
        exchange.put(Service.Mode.class, (Object)this.implInfo.getServiceMode());
        exchange.put(Class.class, this.implInfo.getProviderParameterType());
        exchange.put(Endpoint.class, (Object)this.endpoint);
        exchange.put(Service.class, (Object)this.endpoint.getService());
        exchange.put(Binding.class, (Object)this.endpoint.getBinding());
        exchange.put(Bus.class, (Object)this.bus);
        exchange.setDestination(m.getDestination());
        PhaseInterceptorChain chain = new PhaseInterceptorChain(((PhaseManager)this.bus.getExtension(PhaseManager.class)).getInPhases());
        message.setInterceptorChain((InterceptorChain)chain);
        chain.add(this.bus.getInInterceptors());
        this.endpoint.getInInterceptors().clear();
        chain.add(this.endpoint.getInInterceptors());
        this.endpoint.getBinding().getInInterceptors().clear();
        this.endpoint.getBinding().getInInterceptors().add(new DispatchInInterceptor());
        chain.add(this.endpoint.getBinding().getInInterceptors());
        this.endpoint.getBinding().getOutInterceptors().clear();
        this.endpoint.getBinding().getOutInterceptors().add(new DispatchOutInterceptor());
        chain.add(this.endpoint.getBinding().getOutInterceptors());
        chain.add(this.endpoint.getService().getInInterceptors());
        chain.setFaultObserver(this.endpoint.getOutFaultObserver());
        chain.doIntercept(message);
    }
}

