/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.util.List;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.handler.AbstractJAXWSHandlerInterceptor;
import org.apache.cxf.jaxws.handler.HandlerChainInvoker;
import org.apache.cxf.jaxws.handler.LogicalMessageContextImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalHandlerInterceptor<T extends Message>
extends AbstractJAXWSHandlerInterceptor<T> {
    public LogicalHandlerInterceptor(Binding binding) {
        super(binding);
        this.setPhase("user-logical");
    }

    public void handleMessage(T message) {
        HandlerChainInvoker invoker = this.getInvoker(message);
        if (!invoker.getLogicalHandlers().isEmpty()) {
            LogicalMessageContextImpl lctx = new LogicalMessageContextImpl((Message)message);
            if (!invoker.invokeLogicalHandlers(this.isRequestor(message), lctx)) {
                message.getInterceptorChain().abort();
                MessageImpl responseMsg = new MessageImpl();
                message.getExchange().setInMessage((Message)responseMsg);
                Client client = (Client)message.getExchange().get(Client.class);
                responseMsg.put((Object)"starting_after_interceptor_id", (Object)this.getId());
                if (client != null) {
                    List inObj;
                    Source inSource = (Source)message.getContent(Source.class);
                    if (inSource != null) {
                        responseMsg.setContent(Source.class, (Object)inSource);
                    }
                    if ((inObj = (List)message.getContent(List.class)) != null) {
                        responseMsg.setContent(List.class, (Object)inObj);
                    }
                    client.onMessage((Message)responseMsg);
                } else if (!message.getExchange().isOneWay()) {
                    // empty if block
                }
            }
        }
    }

    public void handleFault(T message) {
    }

    public void onCompletion(T message) {
        if (this.isRequestor(message) && (this.isOneway(message) || !this.isOutbound(message))) {
            this.getInvoker(message).mepComplete((Message)message);
        }
    }
}

