/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.handler;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.jaxws.handler.StreamMessageContext;
import org.apache.cxf.message.Message;

public class StreamMessageContextImpl
extends WrappedMessageContext
implements StreamMessageContext {
    private static final Logger LOG = LogUtils.getL7dLogger(StreamMessageContextImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public StreamMessageContextImpl(Message m) {
        super(m);
    }

    public InputStream getInputStream() {
        InputStream is = (InputStream)this.getWrappedMessage().getContent(InputStream.class);
        if (is == null) {
            throw new IllegalStateException(BUNDLE.getString("NO_INPUT_STREAM_EXC"));
        }
        return is;
    }

    public void setInputStream(InputStream is) {
        this.getWrappedMessage().setContent(InputStream.class, (Object)is);
    }

    public OutputStream getOutputStream() {
        OutputStream os = (OutputStream)this.getWrappedMessage().getContent(OutputStream.class);
        if (os == null) {
            throw new IllegalStateException(BUNDLE.getString("NO_OUTPUT_STREAM_EXC"));
        }
        return os;
    }

    public void setOutputStream(OutputStream os) {
        this.getWrappedMessage().setContent(OutputStream.class, (Object)os);
    }
}

