/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.Service;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.XMLMessage;
import org.apache.cxf.service.Service;

public class DispatchInInterceptor
extends AbstractInDatabindingInterceptor {
    public DispatchInInterceptor() {
        this.setPhase("read");
    }

    public void handleMessage(Message message) throws Fault {
        Service.Mode m = (Service.Mode)message.getExchange().get(Service.Mode.class);
        Class type = (Class)message.getExchange().get(Class.class);
        try {
            this.resetContext(message);
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (message instanceof SoapMessage) {
                SOAPMessage soapMessage = this.newSOAPMessage(is, ((SoapMessage)message).getVersion());
                if (m == Service.Mode.MESSAGE) {
                    DataReader dataReader = this.getDataReader(message, SOAPMessage.class);
                    message.setContent(Object.class, dataReader.read(null, (Object)soapMessage, type));
                } else if (m == Service.Mode.PAYLOAD) {
                    DataReader dataReader = this.getDataReader(message, SOAPBody.class);
                    message.setContent(Object.class, dataReader.read(null, (Object)soapMessage.getSOAPBody(), type));
                }
            } else if (message instanceof XMLMessage) {
                DataReader dataReader = this.getDataReader(message, XMLMessage.class);
                message.setContent(Object.class, dataReader.read(null, (Object)((XMLMessage)message), type));
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private void resetContext(Message message) throws JAXBException {
        JAXBContext context = (JAXBContext)message.getContent(JAXBContext.class);
        if (context != null) {
            Service service = (Service)message.getExchange().get(Service.class);
            JAXBDataBinding dataBinding = new JAXBDataBinding();
            dataBinding.setContext(context);
            service.setDataBinding((DataBinding)dataBinding);
        }
    }

    private SOAPMessage newSOAPMessage(InputStream is, SoapVersion version) throws Exception {
        MimeHeaders headers = new MimeHeaders();
        MessageFactory msgFactory = null;
        if (version == null || version instanceof Soap11) {
            msgFactory = MessageFactory.newInstance();
        } else if (version instanceof Soap12) {
            msgFactory = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        return msgFactory.createMessage(headers, is);
    }
}

