/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.databinding.DataWriterFactory;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebFaultOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JaxWsServiceConfiguration.class);

    public WebFaultOutInterceptor() {
        this.setPhase("pre-protocol");
    }

    public void handleMessage(Message message) throws Fault {
        Fault f = (Fault)message.getContent(Exception.class);
        Throwable cause = f.getCause();
        if (cause instanceof Exception && cause.getClass().isAnnotationPresent(WebFault.class)) {
            Exception ex = (Exception)cause;
            try {
                Method method = cause.getClass().getMethod("getFaultInfo", new Class[0]);
                Object faultInfo = method.invoke((Object)cause, new Object[0]);
                Service service = (Service)message.getExchange().get(Service.class);
                DataWriterFactory writerFactory = service.getDataBinding().getDataWriterFactory();
                DataWriter writer = writerFactory.createWriter(Node.class);
                OperationInfo op = ((BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class)).getOperationInfo();
                QName faultName = this.getFaultName(ex);
                MessagePartInfo part = this.getFaultMessagePart(faultName, op);
                writer.write(faultInfo, part, (Object)f.getOrCreateDetail());
                f.setMessage(ex.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("INVOCATION_TARGET_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NO_GETFAULTINFO_METHOD", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("COULD_NOT_INVOKE", BUNDLE, new Object[0]), (Throwable)e);
            }
        }
    }

    private QName getFaultName(Exception webFault) {
        WebFault wf = webFault.getClass().getAnnotation(WebFault.class);
        return new QName(wf.targetNamespace(), wf.name());
    }

    private MessagePartInfo getFaultMessagePart(QName qname, OperationInfo op) {
        if (op.isUnwrapped()) {
            op = ((UnwrappedOperationInfo)op).getWrappedOperation();
        }
        for (FaultInfo faultInfo : op.getFaults()) {
            for (MessagePartInfo mpi : faultInfo.getMessageParts()) {
                String ns = null;
                ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                if (!qname.getLocalPart().equals(mpi.getConcreteName().getLocalPart()) || !qname.getNamespaceURI().equals(ns)) continue;
                return mpi;
            }
        }
        return null;
    }
}

