/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextPropertiesMapping {
    private static Map<String, String> cxf2jaxwsMap = new HashMap<String, String>();
    private static Map<String, String> jaxws2cxfMap = new HashMap<String, String>();

    private ContextPropertiesMapping() {
    }

    private static void mapContext(Map<String, Object> context, Map<String, String> map) {
        Set<String> keyset = context.keySet();
        String[] keys = new String[]{};
        keys = keyset.toArray(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            String mappingString = map.get(key);
            if (null == mappingString) continue;
            Object obj = context.get(key);
            context.put(mappingString, obj);
        }
    }

    public static void mapRequestfromJaxws2Cxf(Map<String, Object> context) {
        Object requestHeaders = context.get("javax.xml.ws.http.request.headers");
        if (null != requestHeaders) {
            context.put(Message.PROTOCOL_HEADERS, requestHeaders);
        }
        ContextPropertiesMapping.mapJaxws2Cxf(context);
    }

    public static void mapResponsefromCxf2Jaxws(Map<String, Object> context) {
        Object responseHeaders = context.get(Message.PROTOCOL_HEADERS);
        if (null != responseHeaders) {
            context.put("javax.xml.ws.http.response.headers", responseHeaders);
        }
        ContextPropertiesMapping.mapCxf2Jaxws(context);
    }

    private static void mapJaxws2Cxf(Map<String, Object> context) {
        ContextPropertiesMapping.mapContext(context, jaxws2cxfMap);
    }

    private static void mapCxf2Jaxws(Map<String, Object> context) {
        ContextPropertiesMapping.mapContext(context, cxf2jaxwsMap);
    }

    public static MessageContext createWebServiceContext(Exchange exchange) {
        Message outMessage;
        WrappedMessageContext ctx = new WrappedMessageContext(exchange.getInMessage());
        ContextPropertiesMapping.mapCxf2Jaxws((Map<String, Object>)((Object)ctx));
        Object requestHeaders = exchange.getInMessage().get((Object)Message.PROTOCOL_HEADERS);
        if (null != requestHeaders) {
            ctx.put("javax.xml.ws.http.request.headers", requestHeaders);
        }
        if (null != (outMessage = exchange.getOutMessage())) {
            HashMap responseHeaders = outMessage.get((Object)Message.PROTOCOL_HEADERS);
            if (responseHeaders == null) {
                responseHeaders = new HashMap();
                outMessage.put((Object)Message.PROTOCOL_HEADERS, responseHeaders);
            }
            ctx.put("javax.xml.ws.http.response.headers", responseHeaders);
        }
        return ctx;
    }

    public static void updateWebServiceContext(Exchange exchange, MessageContext ctx) {
        if (ctx.containsKey((Object)"javax.xml.ws.http.response.code")) {
            exchange.getOutMessage().put((Object)Message.RESPONSE_CODE, ctx.get((Object)"javax.xml.ws.http.response.code"));
        }
    }

    static {
        cxf2jaxwsMap.put(Message.ENDPOINT_ADDRESS, "javax.xml.ws.service.endpoint.address");
        cxf2jaxwsMap.put(Message.USERNAME, "javax.xml.ws.security.auth.username");
        cxf2jaxwsMap.put(Message.PASSWORD, "javax.xml.ws.security.auth.password");
        cxf2jaxwsMap.put(Message.HTTP_REQUEST_METHOD, "javax.xml.ws.http.request.method");
        cxf2jaxwsMap.put(Message.RESPONSE_CODE, "javax.xml.ws.http.response.code");
        cxf2jaxwsMap.put(Message.PATH_INFO, "javax.xml.ws.http.request.pathinfo");
        cxf2jaxwsMap.put(Message.QUERY_STRING, "javax.xml.ws.http.request.querystring");
        jaxws2cxfMap.put("javax.xml.ws.service.endpoint.address", Message.ENDPOINT_ADDRESS);
        jaxws2cxfMap.put("javax.xml.ws.security.auth.username", Message.USERNAME);
        jaxws2cxfMap.put("javax.xml.ws.security.auth.password", Message.PASSWORD);
        jaxws2cxfMap.put("javax.xml.ws.http.request.method", Message.HTTP_REQUEST_METHOD);
        jaxws2cxfMap.put("javax.xml.ws.http.response.code", Message.RESPONSE_CODE);
        jaxws2cxfMap.put("javax.xml.ws.http.request.pathinfo", Message.PATH_INFO);
        jaxws2cxfMap.put("javax.xml.ws.http.request.querystring", Message.QUERY_STRING);
    }
}

