/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxws.interceptors.WebFaultOutInterceptor;
import org.apache.cxf.jaxws.support.AbstractJaxWsServiceFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.JaxWsServiceConfiguration;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsServiceFactoryBean
extends AbstractJaxWsServiceFactoryBean {
    public static final String MODE_OUT = "messagepart.mode.out";
    public static final String MODE_INOUT = "messagepart.mode.inout";
    public static final String HOLDER = "messagepart.isholder";
    private JaxWsServiceConfiguration jaxWsConfiguration = new JaxWsServiceConfiguration();

    public JaxWsServiceFactoryBean() {
        this.getServiceConfigurations().add(0, this.jaxWsConfiguration);
        this.getIgnoredClasses().add(Service.class.getName());
    }

    public JaxWsServiceFactoryBean(JaxWsImplementorInfo implInfo) {
        this();
        this.setJaxWsImplementorInfo(implInfo);
        this.serviceClass = implInfo.getImplementorClass();
    }

    public void setServiceClass(Class<?> serviceClass) {
        if (this.getJaxWsImplementorInfo() == null) {
            this.setJaxWsImplementorInfo(new JaxWsImplementorInfo(serviceClass));
        }
        super.setServiceClass(serviceClass);
    }

    protected void initializeDefaultInterceptors() {
        super.initializeDefaultInterceptors();
        this.getService().getOutFaultInterceptors().add(new WebFaultOutInterceptor());
    }

    protected Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new JaxWsEndpointImpl(this.getBus(), this.getService(), ei);
    }

    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method method) {
        method = this.jaxWsConfiguration.getDeclaredMethod(method);
        super.initializeWSDLOperation(intf, o, method);
        this.initializeWrapping(o, method);
        try {
            Method responseMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", method.getParameterTypes());
            ArrayList asyncHandlerParams = new ArrayList(Arrays.asList(method.getParameterTypes()));
            asyncHandlerParams.add(AsyncHandler.class);
            Method futureMethod = method.getDeclaringClass().getDeclaredMethod(method.getName() + "Async", asyncHandlerParams.toArray(new Class[asyncHandlerParams.size()]));
            this.getMethodDispatcher().bind(o, new Method[]{method, responseMethod, futureMethod});
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.getMethodDispatcher().bind(o, new Method[]{method});
        }
        Operation op = (Operation)o.getProperty(WSDLServiceBuilder.WSDL_OPERATION);
        this.initializeClassInfo(o, method, op == null ? null : op.getParameterOrdering());
    }

    void initializeWrapping(OperationInfo o, Method selected) {
        Class requestWrapper;
        Class responseWrapper = this.getResponseWrapper(selected);
        if (responseWrapper != null) {
            ((MessagePartInfo)o.getOutput().getMessageParts().get(0)).setTypeClass(responseWrapper);
        }
        if ((requestWrapper = this.getRequestWrapper(selected)) != null) {
            ((MessagePartInfo)o.getInput().getMessageParts().get(0)).setTypeClass(requestWrapper);
        }
    }

    private void setFaultClassInfo(OperationInfo o, Method selected) {
        Class<?>[] types = selected.getExceptionTypes();
        for (int i = 0; i < types.length; ++i) {
            Class<?> exClass = types[i];
            Class beanClass = this.getBeanClass(exClass);
            QName name = this.getFaultName(o.getInterface(), o, exClass, beanClass);
            for (FaultInfo fi : o.getFaults()) {
                for (MessagePartInfo mpi : fi.getMessageParts()) {
                    String ns = null;
                    ns = mpi.isElement() ? mpi.getElementQName().getNamespaceURI() : mpi.getTypeQName().getNamespaceURI();
                    if (!mpi.getConcreteName().getLocalPart().equals(name.getLocalPart()) || !name.getNamespaceURI().equals(ns)) continue;
                    fi.setProperty(Class.class.getName(), exClass);
                    mpi.setTypeClass(beanClass);
                }
            }
        }
    }

    protected Class getBeanClass(Class exClass) {
        try {
            Method getFaultInfo = exClass.getMethod("getFaultInfo", new Class[0]);
            return getFaultInfo.getReturnType();
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            return super.getBeanClass(exClass);
        }
    }

    protected void initializeClassInfo(OperationInfo o, Method method, List<String> paramOrder) {
        if (this.isWrapped(method)) {
            MessagePartInfo part;
            MessageInfo input;
            if (o.hasInput()) {
                input = o.getInput();
                part = (MessagePartInfo)input.getMessageParts().get(0);
                part.setTypeClass(this.getRequestWrapper(method));
            }
            if (o.hasOutput()) {
                input = o.getOutput();
                part = (MessagePartInfo)input.getMessageParts().get(0);
                part.setTypeClass(this.getResponseWrapper(method));
            }
            this.setFaultClassInfo(o, method);
            o = o.getUnwrappedOperation();
        } else if (o.isUnwrappedCapable()) {
            o.setUnwrappedOperation(null);
            this.setFaultClassInfo(o, method);
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        Type[] genericTypes = method.getGenericParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            Type genericType = genericTypes[i];
            this.initializeParameter(o, method, i, paramType, genericType);
        }
        Class<?> paramType = method.getReturnType();
        Type genericType = method.getGenericReturnType();
        this.initializeParameter(o, method, -1, paramType, genericType);
        this.setFaultClassInfo(o, method);
    }

    private void initializeParameter(OperationInfo o, Method method, int i, Class paramType, Type genericType) {
        if (this.isWrapped(method)) {
            return;
        }
        boolean isIn = this.isInParam(method, i);
        boolean isOut = this.isOutParam(method, i);
        if (isIn && !isOut) {
            QName name = this.getInPartName(o, method, i);
            MessagePartInfo part = o.getInput().getMessagePart(name);
            this.initializeParameter(part, paramType, genericType);
        } else if (!isIn && isOut) {
            QName name = this.getOutPartName(o, method, i);
            MessagePartInfo part = o.getOutput().getMessagePart(name);
            this.initializeParameter(part, paramType, genericType);
        } else if (isIn && isOut) {
            QName name = this.getOutPartName(o, method, i);
            MessagePartInfo part = o.getInput().getMessagePart(name);
            part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
            part = o.getOutput().getMessagePart(name);
            part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
            this.initializeParameter(part, paramType, genericType);
        }
    }

    private void initializeParameter(MessagePartInfo part, Class rawClass, Type type) {
        if (rawClass.equals(Holder.class) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            rawClass = JaxWsServiceFactoryBean.getHolderClass(paramType);
        }
        part.setProperty("generic.type", (Object)type);
        part.setTypeClass(rawClass);
    }

    private static Class getHolderClass(ParameterizedType paramType) {
        Class<?> rawClass;
        Type rawType = paramType.getActualTypeArguments()[0];
        if (rawType instanceof GenericArrayType) {
            rawClass = (Class<?>)((GenericArrayType)rawType).getGenericComponentType();
            rawClass = Array.newInstance(rawClass, 0).getClass();
        } else {
            if (rawType instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)rawType).getRawType();
            }
            rawClass = (Class)rawType;
        }
        return rawClass;
    }

    public void setJaxWsConfiguration(JaxWsServiceConfiguration jaxWsConfiguration) {
        this.jaxWsConfiguration = jaxWsConfiguration;
    }
}

