/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.namespace.QName;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.support.AbstractJaxWsServiceFactoryBean;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsImplementorInfo;
import org.apache.cxf.jaxws.support.WebServiceProviderConfiguration;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class ProviderServiceFactoryBean
extends AbstractJaxWsServiceFactoryBean {
    private String bindingURI;

    public ProviderServiceFactoryBean(JaxWsImplementorInfo implInfo) {
        this.setJaxWsImplementorInfo(implInfo);
        this.bindingURI = implInfo.getBindingType();
        this.getServiceConfigurations().add(0, new WebServiceProviderConfiguration());
        this.setServiceClass(implInfo.getImplementorClass());
        this.setWrapped(false);
    }

    protected void initializeWSDLOperations() {
        Type[] genericInterfaces = this.getServiceClass().getGenericInterfaces();
        ParameterizedType pt = (ParameterizedType)genericInterfaces[0];
        Class c = (Class)pt.getActualTypeArguments()[0];
        try {
            Method invoke = this.getServiceClass().getMethod("invoke", c);
            for (OperationInfo o : this.getService().getServiceInfo().getInterface().getOperations()) {
                this.getMethodDispatcher().bind(o, new Method[]{invoke});
            }
        }
        catch (SecurityException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
    }

    protected Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new JaxWsEndpointImpl(this.getBus(), this.getService(), ei);
    }

    protected InterfaceInfo createInterface(ServiceInfo serviceInfo) {
        InterfaceInfo intf = new InterfaceInfo(serviceInfo, this.getInterfaceName());
        String ns = this.getServiceNamespace();
        OperationInfo invoke = intf.addOperation(new QName(ns, "invoke"));
        MessageInfo input = invoke.createMessage(new QName(ns, "input"));
        invoke.setInput("input", input);
        input.addMessagePart("in");
        MessageInfo output = invoke.createMessage(new QName(ns, "output"));
        invoke.setOutput("output", output);
        output.addMessagePart("out");
        OperationInfo invokeOneWay = intf.addOperation(new QName(this.getServiceNamespace(), "invokeOneWay"));
        invokeOneWay.setInput("input", input);
        return intf;
    }

    public Service create() {
        Service s = super.create();
        if (this.getJaxWsImplementorInfo().getWsdlLocation().length() == 0) {
            this.initializeBindings();
        }
        return s;
    }

    protected void initializeBindings() {
        ServiceInfo si = this.getService().getServiceInfo();
        if ("http://cxf.apache.org/bindings/xformat".equals(this.bindingURI)) {
            BindingInfo bi = new BindingInfo(si, this.bindingURI);
            BindingOperationInfo bop = bi.buildOperation(new QName(this.getServiceNamespace(), "invoke"), "input", "output");
            bi.addOperation(bop);
            bi.setName(new QName(this.getServiceNamespace(), this.getServiceName() + "Binding"));
            si.addBinding(bi);
            EndpointInfo ei = new EndpointInfo(si, this.bindingURI);
            ei.setBinding(bi);
            ei.setName(new QName(this.getServiceName() + "Port"));
            si.addEndpoint(ei);
        } else if ("soapns".equals(this.bindingURI)) {
            // empty if block
        }
    }

    protected void initializeDataBindings() {
        this.setDataBinding((DataBinding)new JAXBDataBinding());
        super.initializeDataBindings();
    }

    public String getBindingURI() {
        return this.bindingURI;
    }

    public void setBindingURI(String bindingURI) {
        this.bindingURI = bindingURI;
    }
}

