/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.SequenceFault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRMInterceptor
implements PhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractRMInterceptor.class);
    private RMManager manager;
    private Bus bus;

    public RMManager getManager() {
        if (null == this.manager) {
            return (RMManager)((Object)this.bus.getExtension(RMManager.class));
        }
        return this.manager;
    }

    public void setManager(RMManager m) {
        this.manager = m;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public String getPhase() {
        return "pre-logical";
    }

    public void handleMessage(Message msg) throws Fault {
        try {
            this.handleMessage(msg, false);
        }
        catch (SequenceFault ex) {
            LOG.log(Level.SEVERE, "SequenceFault", ex);
            throw new Fault((Throwable)ex);
        }
    }

    public void handleFault(Message msg) {
        try {
            this.handleMessage(msg, true);
        }
        catch (SequenceFault ex) {
            LOG.log(Level.SEVERE, "SequenceFault", ex);
        }
    }

    abstract void handleMessage(Message var1, boolean var2) throws SequenceFault;
}

