/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.MAPAggregator;
import org.apache.cxf.ws.rm.AbstractRMInterceptor;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.SequenceType;
import org.apache.cxf.ws.rm.SourceSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMInInterceptor
extends AbstractRMInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(RMInInterceptor.class);
    private Set<String> before = Collections.singleton(MAPAggregator.class.getName());

    public Set<String> getBefore() {
        return this.before;
    }

    public Set<String> getAfter() {
        return CastUtils.cast((Set)Collections.EMPTY_SET);
    }

    public String getId() {
        return RMInInterceptor.class.getName();
    }

    @Override
    void handleMessage(Message message, boolean isFault) throws SequenceFault {
        Object originalRequestor;
        LOG.entering(this.getClass().getName(), "handleMessage");
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        assert (null != maps);
        String action = null;
        if (null != maps.getAction()) {
            action = maps.getAction().getValue();
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Action: " + action);
        }
        if (null != (originalRequestor = message.get((Object)"org.apache.cxf.client.original"))) {
            LOG.fine("Restoring original requestor role to: " + originalRequestor);
            message.put((Object)"org.apache.cxf.client", originalRequestor);
        }
        if (RMConstants.getCreateSequenceAction().equals(action) || RMConstants.getCreateSequenceResponseAction().equals(action) || RMConstants.getTerminateSequenceAction().equals(action)) {
            InterceptorChain chain = message.getInterceptorChain();
            ListIterator it = chain.getIterator();
            while (it.hasNext()) {
                PhaseInterceptor pi = (PhaseInterceptor)it.next();
                if (!"org.apache.cxf.jaxws.interceptors.WrapperClassInInterceptor".equals(pi.getId())) continue;
                chain.remove((Interceptor)pi);
                LOG.fine("Removed WrapperClassInInterceptor from interceptor chain.");
                break;
            }
            return;
        }
        if (RMConstants.getSequenceAckAction().equals(action)) {
            this.processAcknowledgments(rmps);
            return;
        }
        Destination destination = this.getManager().getDestination(message);
        if (null != rmps) {
            this.processAcknowledgments(rmps);
            this.processAcknowledgmentRequests(rmps);
            this.processSequence(destination, rmps, (AddressingProperties)maps);
            this.processDeliveryAssurance(rmps);
        }
    }

    void processAcknowledgments(RMProperties rmps) throws SequenceFault {
        Collection<SequenceAcknowledgement> acks = rmps.getAcks();
        if (null != acks) {
            for (SequenceAcknowledgement ack : acks) {
                Identifier id = ack.getIdentifier();
                SourceSequence ss = this.getManager().getSourceSequence(id);
                if (null != ss) {
                    ss.setAcknowledged(ack);
                    continue;
                }
                throw new SequenceFaultFactory().createUnknownSequenceFault(id);
            }
        }
    }

    void processAcknowledgmentRequests(RMProperties rmps) {
    }

    void processSequence(Destination destination, RMProperties rmps, AddressingProperties maps) throws SequenceFault {
        SequenceType s = rmps.getSequence();
        if (null == s) {
            return;
        }
        destination.acknowledge(s, null == maps.getReplyTo() ? null : maps.getReplyTo().getAddress().getValue());
    }

    void processDeliveryAssurance(RMProperties rmps) {
    }
}

