/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.Duration;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxb.DatatypeFactory;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.rm.AbstractSequence;
import org.apache.cxf.ws.rm.Destination;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.Expires;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.Proxy;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMUtils;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.Source;
import org.apache.cxf.ws.rm.manager.SequenceTerminationPolicyType;

public class SourceSequence
extends AbstractSequence {
    private static final Logger LOG = LogUtils.getL7dLogger(SourceSequence.class);
    private Date expires;
    private Source source;
    private BigInteger currentMessageNumber;
    private boolean lastMessage;
    private Identifier offeringId;
    private EndpointReferenceType target;

    public SourceSequence(Identifier i) {
        this(i, null, null);
    }

    public SourceSequence(Identifier i, Date e, Identifier oi) {
        this(i, e, oi, BigInteger.ZERO, false);
    }

    public SourceSequence(Identifier i, Date e, Identifier oi, BigInteger cmn, boolean lm) {
        super(i);
        this.expires = e;
        this.offeringId = oi;
        this.currentMessageNumber = cmn;
        this.lastMessage = lm;
        this.acknowledgement = RMUtils.getWSRMFactory().createSequenceAcknowledgement();
        this.acknowledgement.setIdentifier(this.id);
    }

    public BigInteger getCurrentMessageNr() {
        return this.currentMessageNumber;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public Identifier getOfferingSequenceIdentifier() {
        return this.offeringId;
    }

    public String getEndpointIdentifier() {
        return this.source.getName().toString();
    }

    public Date getExpires() {
        return this.expires;
    }

    public boolean offeredBy(Identifier sid) {
        return null != this.offeringId && this.offeringId.getValue().equals(sid.getValue());
    }

    public boolean allAcknowledged() {
        if (!this.lastMessage) {
            return false;
        }
        if (this.acknowledgement.getAcknowledgementRange().size() == 1) {
            SequenceAcknowledgement.AcknowledgementRange r = this.acknowledgement.getAcknowledgementRange().get(0);
            return r.getLower().equals(BigInteger.ONE) && r.getUpper().equals(this.currentMessageNumber);
        }
        return false;
    }

    public void setAcknowledged(SequenceAcknowledgement a) {
        this.acknowledgement = a;
        this.source.getManager().getRetransmissionQueue().purgeAcknowledged(this);
        if (this.allAcknowledged()) {
            RMEndpoint rme = this.source.getReliableEndpoint();
            Proxy proxy = rme.getProxy();
            try {
                proxy.terminate(this);
                this.source.getManager().removeSourceSequence(this.id);
            }
            catch (IOException ex) {
                Message msg = new Message("SEQ_TERMINATION_FAILURE", LOG, new Object[]{this.id});
                LOG.log(Level.SEVERE, msg.toString(), ex);
            }
        }
    }

    public Source getSource() {
        return this.source;
    }

    void setSource(Source s) {
        this.source = s;
    }

    void setLastMessage(boolean lm) {
        this.lastMessage = lm;
    }

    boolean isExpired() {
        return this.expires == null ? false : new Date().after(this.expires);
    }

    public void setExpires(Expires ex) {
        Duration d = null;
        this.expires = null;
        if (null != ex) {
            d = ex.getValue();
        }
        if (null != d && !d.equals(DatatypeFactory.PT0S)) {
            Date now = new Date();
            this.expires = new Date(now.getTime() + ex.getValue().getTimeInMillis(now));
        }
    }

    BigInteger nextMessageNumber() {
        return this.nextMessageNumber(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger nextMessageNumber(Identifier inSeqId, BigInteger inMsgNumber) {
        assert (!this.lastMessage);
        BigInteger result = null;
        SourceSequence sourceSequence = this;
        synchronized (sourceSequence) {
            this.currentMessageNumber = this.currentMessageNumber.add(BigInteger.ONE);
            this.checkLastMessage(inSeqId, inMsgNumber);
            result = this.currentMessageNumber;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void nextAndLastMessageNumber() {
        assert (!this.lastMessage);
        SourceSequence sourceSequence = this;
        synchronized (sourceSequence) {
            this.currentMessageNumber = this.currentMessageNumber.add(BigInteger.ONE);
            this.lastMessage = true;
        }
    }

    SequenceAcknowledgement getAcknowledgement() {
        return this.acknowledgement;
    }

    synchronized void setTarget(EndpointReferenceType to) {
        if (this.target == null && !ContextUtils.isGenericAddress((EndpointReferenceType)to)) {
            this.target = to;
        }
    }

    synchronized EndpointReferenceType getTarget() {
        return this.target;
    }

    private void checkLastMessage(Identifier inSeqId, BigInteger inMsgNumber) {
        if (null != inSeqId && null != inMsgNumber) {
            Destination destination = this.source.getReliableEndpoint().getDestination();
            DestinationSequence inSeq = null;
            if (null != destination) {
                inSeq = destination.getSequence(inSeqId);
            }
            if (null != inSeq && this.offeredBy(inSeqId) && inMsgNumber.equals(inSeq.getLastMessageNumber())) {
                this.lastMessage = true;
            }
        }
        if (!this.lastMessage) {
            SequenceTerminationPolicyType stp = this.source.getManager().getSourcePolicy().getSequenceTerminationPolicy();
            assert (null != stp);
            if (!stp.getMaxLength().equals(BigInteger.ZERO) && stp.getMaxLength().compareTo(this.currentMessageNumber) <= 0 || stp.getMaxRanges() > 0 && this.acknowledgement.getAcknowledgementRange().size() >= stp.getMaxRanges() || stp.getMaxUnacknowledged() > 0 && this.source.getManager().getRetransmissionQueue().countUnacknowledged(this) >= stp.getMaxUnacknowledged()) {
                this.lastMessage = true;
            }
        }
        if (LOG.isLoggable(Level.FINE) && this.lastMessage) {
            LOG.fine(this.currentMessageNumber + " should be the last message in this sequence.");
        }
    }
}

