/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.message;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageImpl
extends HashMap<String, Object>
implements Message {
    private Collection<Attachment> attachments;
    private Conduit conduit;
    private Destination destination;
    private Exchange exchange;
    private String id;
    private InterceptorChain interceptorChain;
    private Map<Class<?>, Object> contents = new HashMap();

    @Override
    public Collection<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    public String getAttachmentMimeType() {
        return null;
    }

    @Override
    public Conduit getConduit() {
        return this.conduit;
    }

    @Override
    public Destination getDestination() {
        return this.destination;
    }

    @Override
    public Exchange getExchange() {
        return this.exchange;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T> T getContent(Class<T> format) {
        return format.cast(this.contents.get(format));
    }

    @Override
    public <T> void setContent(Class<T> format, Object content) {
        this.contents.put(format, content);
    }

    @Override
    public Set<Class<?>> getContentFormats() {
        return this.contents.keySet();
    }

    public void setConduit(Conduit c) {
        this.conduit = c;
    }

    public void setDestination(Destination d) {
        this.destination = d;
    }

    @Override
    public void setExchange(Exchange e) {
        this.exchange = e;
    }

    @Override
    public void setId(String i) {
        this.id = i;
    }

    @Override
    public void setInterceptorChain(InterceptorChain ic) {
        this.interceptorChain = ic;
    }

    @Override
    public <T> T get(Class<T> key) {
        return key.cast(this.get(key.getName()));
    }

    @Override
    public <T> void put(Class<T> key, T value) {
        this.put(key.getName(), value);
    }

    @Override
    public Object getContextualProperty(String key) {
        Object ep;
        Object val = this.get(key);
        if (val == null) {
            val = this.getExchange().get(key);
        }
        if (val == null && (ep = this.get(OperationInfo.class)) != null) {
            val = ((AbstractPropertiesHolder)ep).getProperty(key);
        }
        if (val == null && (ep = this.getExchange().get(Endpoint.class)) != null) {
            val = ep.get(key);
            if (val == null) {
                val = ep.getEndpointInfo().getProperty(key);
            }
            if (val == null) {
                val = ep.getEndpointInfo().getBinding().getProperty(key);
            }
        }
        if (val == null && (ep = this.getExchange().get(Service.class)) != null) {
            val = ep.get(key);
        }
        return val;
    }

    public static void copyContent(Message m1, Message m2) {
        for (Class<?> c : m1.getContentFormats()) {
            if (c == Exception.class) {
                m2.setContent(c, m1.getContent(c));
                continue;
            }
            if (c != XMLStreamReader.class) continue;
            m2.setContent(c, m1.getContent(c));
        }
    }
}

