/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.phase;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhaseInterceptorChain
implements InterceptorChain {
    private static final Logger LOG = Logger.getLogger(PhaseInterceptorChain.class.getName());
    private final Map<Phase, List<Interceptor>> interceptors = new TreeMap<Phase, List<Interceptor>>();
    private final Map<String, List<Interceptor>> nameMap = new HashMap<String, List<Interceptor>>();
    private InterceptorChain.State state = InterceptorChain.State.EXECUTING;
    private Stack<InterceptorChain.State> subChainState = new Stack();
    private PhaseInterceptorIterator iterator;
    private Message pausedMessage;
    private MessageObserver faultObserver;
    private boolean faultOccured;

    public PhaseInterceptorChain(List<Phase> ps) {
        for (Phase phase : ps) {
            ArrayList ints = new ArrayList();
            this.interceptors.put(phase, ints);
            this.nameMap.put(phase.getName(), ints);
        }
        this.iterator = new PhaseInterceptorIterator();
    }

    public void add(List<Interceptor> newhandlers) {
        if (newhandlers == null) {
            return;
        }
        for (Interceptor handler : newhandlers) {
            this.add(handler);
        }
    }

    @Override
    public void add(Interceptor i) {
        String phaseName;
        List<Interceptor> phase;
        PhaseInterceptor pi = (PhaseInterceptor)i;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Adding interceptor " + i + " to phase " + pi.getPhase());
        }
        if ((phase = this.nameMap.get(phaseName = pi.getPhase())) == null) {
            LOG.fine("Phase " + phaseName + " does not exist. Skipping handler " + i.getClass().getName());
        } else {
            this.insertInterceptor(phase, pi);
        }
    }

    @Override
    public void pause() {
        this.state = InterceptorChain.State.PAUSED;
    }

    @Override
    public void finishSubChain() {
        if (!this.subChainState.isEmpty()) {
            this.subChainState.pop();
            this.subChainState.push(InterceptorChain.State.SUBCHAIN_COMPLETE);
        }
    }

    @Override
    public void resume() {
        if (this.state == InterceptorChain.State.PAUSED) {
            this.state = InterceptorChain.State.EXECUTING;
            this.doIntercept(this.pausedMessage);
        }
    }

    @Override
    public boolean doIntercept(Message message) {
        while (this.state == InterceptorChain.State.EXECUTING && this.iterator.hasNext()) {
            try {
                Object currentInterceptor = this.iterator.next();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Invoking handleMessage on interceptor " + currentInterceptor);
                }
                currentInterceptor.handleMessage(message);
                if (this.subChainState.empty() || this.subChainState.peek() != InterceptorChain.State.SUBCHAIN_COMPLETE) continue;
                return true;
            }
            catch (RuntimeException ex) {
                if (!this.faultOccured) {
                    if (this.subChainState.size() > 0 && this.subChainState.peek().equals((Object)InterceptorChain.State.EXECUTING)) {
                        throw ex;
                    }
                    this.faultOccured = true;
                    if (LOG.isLoggable(Level.INFO)) {
                        LogUtils.log((Logger)LOG, (Level)Level.INFO, (String)"Interceptor has thrown exception, unwinding now", (Throwable)ex, (Object[])new Object[0]);
                    }
                    message.setContent(Exception.class, ex);
                    if (message.getExchange() != null) {
                        message.getExchange().put(Exception.class, ex);
                    }
                    this.unwind(message);
                    if (this.faultObserver != null) {
                        this.faultObserver.onMessage(message);
                    }
                }
                this.state = InterceptorChain.State.ABORTED;
            }
        }
        if (this.state == InterceptorChain.State.EXECUTING) {
            this.state = InterceptorChain.State.COMPLETE;
        } else if (this.state == InterceptorChain.State.PAUSED) {
            this.pausedMessage = message;
        }
        return this.state == InterceptorChain.State.COMPLETE;
    }

    @Override
    public boolean doIntercept(Message message, String startingAfterInterceptorID) {
        PhaseInterceptor currentInterceptor;
        while (this.state == InterceptorChain.State.EXECUTING && this.iterator.hasNext() && !(currentInterceptor = (PhaseInterceptor)this.iterator.next()).getId().equals(startingAfterInterceptorID)) {
        }
        return this.doIntercept(message);
    }

    @Override
    public boolean doInterceptInSubChain(Message message) {
        this.subChainState.push(InterceptorChain.State.SUBCHAIN_EXECUTING);
        boolean result = this.doIntercept(message);
        this.subChainState.pop();
        return result;
    }

    @Override
    public void reset() {
        if (this.state == InterceptorChain.State.COMPLETE) {
            this.state = InterceptorChain.State.EXECUTING;
            this.iterator.reset();
        }
    }

    private void unwind(Message message) {
        while (this.iterator.hasPrevious()) {
            Object currentInterceptor = this.iterator.previous();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.fine("Invoking handleFault on interceptor " + currentInterceptor);
            }
            currentInterceptor.handleFault(message);
        }
    }

    @Override
    public void remove(Interceptor i) {
        PhaseInterceptorIterator it = new PhaseInterceptorIterator();
        while (it.hasNext()) {
            if (it.next() != i) continue;
            it.remove();
        }
    }

    @Override
    public void abort() {
        this.state = InterceptorChain.State.ABORTED;
    }

    @Override
    public Iterator<Interceptor<? extends Message>> iterator() {
        return this.getIterator();
    }

    @Override
    public ListIterator<Interceptor<? extends Message>> getIterator() {
        return new PhaseInterceptorIterator();
    }

    protected void insertInterceptor(List<Interceptor> intercs, PhaseInterceptor interc) {
        if (intercs.size() == 0) {
            intercs.add(interc);
            return;
        }
        int begin = -1;
        int end = intercs.size();
        Set<String> before = interc.getBefore();
        Set<String> after = interc.getAfter();
        for (int i = 0; i < intercs.size(); ++i) {
            PhaseInterceptor cmp = (PhaseInterceptor)intercs.get(i);
            if (cmp.getId() == null) continue;
            if (before.contains(cmp.getId()) && i < end) {
                end = i;
            }
            if (cmp.getBefore().contains(interc.getId()) && i > begin) {
                begin = i;
            }
            if (after.contains(cmp.getId()) && i > begin) {
                begin = i;
            }
            if (!cmp.getAfter().contains(interc.getId()) || i >= end) continue;
            end = i;
        }
        if (end < begin + 1) {
            throw new IllegalStateException("Invalid ordering for handler " + interc.getClass().getName());
        }
        intercs.add(begin + 1, interc);
    }

    @Override
    public MessageObserver getFaultObserver() {
        return this.faultObserver;
    }

    @Override
    public void setFaultObserver(MessageObserver faultObserver) {
        this.faultObserver = faultObserver;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PhaseInterceptorIterator
    implements ListIterator<Interceptor<? extends Message>> {
        List<Interceptor<? extends Message>> called = new ArrayList<Interceptor<? extends Message>>();
        Iterator<List<Interceptor>> phases;
        List<Interceptor> currentPhase;
        Iterator<Interceptor> currentPhaseIterator;
        Interceptor<? extends Message> last;

        PhaseInterceptorIterator() {
            this.phases = PhaseInterceptorChain.this.interceptors.values().iterator();
            if (this.phases.hasNext()) {
                this.currentPhase = this.phases.next();
                this.currentPhaseIterator = this.currentPhase.iterator();
                this.last = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.currentPhaseIterator != null) {
                try {
                    if (this.currentPhaseIterator.hasNext()) {
                        return true;
                    }
                    this.nextPhase();
                }
                catch (ConcurrentModificationException cme) {
                    this.refreshIterator();
                }
                return this.hasNext();
            }
            return false;
        }

        private void refreshIterator() {
            this.currentPhaseIterator = this.currentPhase.iterator();
            if (this.last != null) {
                while (this.currentPhaseIterator.hasNext() && this.last != this.currentPhaseIterator.next()) {
                }
            }
        }

        private void nextPhase() {
            if (this.phases.hasNext()) {
                this.currentPhase = this.phases.next();
                this.currentPhaseIterator = this.currentPhase.iterator();
                this.last = null;
            } else {
                this.currentPhase = null;
                this.currentPhaseIterator = null;
                this.last = null;
            }
        }

        @Override
        public Interceptor<? extends Message> next() {
            if (this.currentPhaseIterator != null) {
                try {
                    this.last = this.currentPhaseIterator.next();
                    this.called.add(this.last);
                    return this.last;
                }
                catch (ConcurrentModificationException cme) {
                    this.refreshIterator();
                    return this.next();
                }
            }
            return null;
        }

        @Override
        public boolean hasPrevious() {
            return !this.called.isEmpty();
        }

        @Override
        public Interceptor<? extends Message> previous() {
            return this.called.remove(this.called.size() - 1);
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Interceptor o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            if (this.currentPhaseIterator != null) {
                this.currentPhaseIterator.remove();
            }
        }

        @Override
        public void set(Interceptor o) {
            throw new UnsupportedOperationException();
        }

        protected void reset() {
            this.phases = PhaseInterceptorChain.this.interceptors.values().iterator();
            if (this.phases.hasNext()) {
                this.currentPhase = this.phases.next();
                this.currentPhaseIterator = this.currentPhase.iterator();
                this.last = null;
            }
        }
    }
}

