/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.AbstractPropertiesHolder;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceInfo
extends AbstractPropertiesHolder {
    QName name;
    String targetNamespace;
    InterfaceInfo intf;
    TypeInfo typeInfo;
    Map<QName, BindingInfo> bindings = new ConcurrentHashMap<QName, BindingInfo>(2);
    Map<QName, EndpointInfo> endpoints = new ConcurrentHashMap<QName, EndpointInfo>(2);

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String ns) {
        this.targetNamespace = ns;
    }

    public void setName(QName n) {
        this.name = n;
    }

    public QName getName() {
        return this.name;
    }

    public InterfaceInfo createInterface(QName qn) {
        this.intf = new InterfaceInfo(this, qn);
        return this.intf;
    }

    public void setInterface(InterfaceInfo inf) {
        this.intf = inf;
    }

    public InterfaceInfo getInterface() {
        return this.intf;
    }

    public BindingInfo getBinding(QName qn) {
        return this.bindings.get(qn);
    }

    public void addBinding(BindingInfo binding) {
        this.bindings.put(binding.getName(), binding);
    }

    public EndpointInfo getEndpoint(QName qn) {
        return this.endpoints.get(qn);
    }

    public void addEndpoint(EndpointInfo ep) {
        this.endpoints.put(ep.getName(), ep);
    }

    public Collection<EndpointInfo> getEndpoints() {
        return Collections.unmodifiableCollection(this.endpoints.values());
    }

    public Collection<BindingInfo> getBindings() {
        return Collections.unmodifiableCollection(this.bindings.values());
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }
}

