/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebService;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.MetadataType;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.wsdl.AttributedQNameType;
import org.apache.cxf.ws.addressing.wsdl.ServiceNameType;
import org.apache.cxf.wsdl.EndpointUtilsException;
import org.apache.cxf.wsdl.WSDLManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EndpointReferenceUtils {
    static WeakHashMap<ServiceInfo, Schema> schemaMap = new WeakHashMap();
    private static final Logger LOG = LogUtils.getL7dLogger(EndpointReferenceUtils.class);
    private static final QName WSDL_LOCATION = new QName("http://www.w3.org/2006/01/wsdl-instance", "wsdlLocation");

    private EndpointReferenceUtils() {
    }

    private static Transformer getTransformer() throws EndpointUtilsException {
        if (System.getProperty("java.vendor").indexOf("IBM") > -1) {
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        }
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new EndpointUtilsException(new Message("COULD_NOT_CREATE_TRANSFORMER", LOG, new Object[0]), tce);
        }
    }

    public static void setServiceAndPortName(EndpointReferenceType ref, QName serviceName, String portName) {
        if (null != serviceName) {
            JAXBElement<ServiceNameType> jaxbElement = EndpointReferenceUtils.getServiceNameType(serviceName, portName);
            MetadataType mt = ref.getMetadata();
            if (null == mt) {
                mt = new MetadataType();
                ref.setMetadata(mt);
            }
            mt.getAny().add(jaxbElement);
        }
    }

    public static JAXBElement<ServiceNameType> getServiceNameType(QName serviceName, String portName) {
        ServiceNameType serviceNameType = new ServiceNameType();
        serviceNameType.setValue(serviceName);
        serviceNameType.setEndpointName(portName);
        org.apache.cxf.ws.addressing.wsdl.ObjectFactory objectFactory = new org.apache.cxf.ws.addressing.wsdl.ObjectFactory();
        return objectFactory.createServiceName(serviceNameType);
    }

    public static QName getServiceName(EndpointReferenceType ref) {
        MetadataType metadata = ref.getMetadata();
        if (metadata != null) {
            for (Object obj : metadata.getAny()) {
                if (obj instanceof Element) {
                    Element node = (Element)obj;
                    if (!node.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing/wsdl") || !node.getLocalName().equals("ServiceName")) continue;
                    String content = node.getTextContent();
                    String namespaceURI = node.getFirstChild().getNamespaceURI();
                    String service = content;
                    if (content.contains(":")) {
                        namespaceURI = EndpointReferenceUtils.getNameSpaceUri(node, content, namespaceURI);
                        service = EndpointReferenceUtils.getService(content);
                    } else {
                        Node nodeAttr = node.getAttributes().getNamedItem("xmlns");
                        namespaceURI = nodeAttr.getNodeValue();
                    }
                    return new QName(namespaceURI, service);
                }
                if (obj instanceof JAXBElement) {
                    Object val = ((JAXBElement)obj).getValue();
                    if (!(val instanceof ServiceNameType)) continue;
                    return ((ServiceNameType)val).getValue();
                }
                if (!(obj instanceof ServiceNameType)) continue;
                return ((ServiceNameType)obj).getValue();
            }
        }
        return null;
    }

    public static String getPortName(EndpointReferenceType ref) {
        MetadataType metadata = ref.getMetadata();
        if (metadata != null) {
            for (Object obj : metadata.getAny()) {
                if (obj instanceof Element) {
                    Element node = (Element)obj;
                    if (!node.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing/wsdl") || !node.getNodeName().contains("ServiceName")) continue;
                    return node.getAttributes().getNamedItem("EndpointName").getTextContent();
                }
                if (obj instanceof JAXBElement) {
                    Object val = ((JAXBElement)obj).getValue();
                    if (!(val instanceof ServiceNameType)) continue;
                    return ((ServiceNameType)val).getEndpointName();
                }
                if (!(obj instanceof ServiceNameType)) continue;
                return ((ServiceNameType)obj).getEndpointName();
            }
        }
        return null;
    }

    public static void setInterfaceName(EndpointReferenceType ref, QName portTypeName) {
        if (null != portTypeName) {
            AttributedQNameType interfaceNameType = new AttributedQNameType();
            interfaceNameType.setValue(portTypeName);
            org.apache.cxf.ws.addressing.wsdl.ObjectFactory objectFactory = new org.apache.cxf.ws.addressing.wsdl.ObjectFactory();
            JAXBElement jaxbElement = objectFactory.createInterfaceName(interfaceNameType);
            MetadataType mt = ref.getMetadata();
            if (null == mt) {
                mt = new MetadataType();
                ref.setMetadata(mt);
            }
            mt.getAny().add(jaxbElement);
        }
    }

    public static QName getInterfaceName(EndpointReferenceType ref) {
        MetadataType metadata = ref.getMetadata();
        if (metadata != null) {
            for (Object obj : metadata.getAny()) {
                if (obj instanceof Element) {
                    Element node = (Element)obj;
                    System.out.println(node.getNamespaceURI() + ":" + node.getNodeName());
                    if (!node.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing/wsdl") || !node.getNodeName().contains("InterfaceName")) continue;
                    String content = node.getTextContent();
                    String namespaceURI = node.getFirstChild().getNamespaceURI();
                    if (content.contains(":")) {
                        namespaceURI = EndpointReferenceUtils.getNameSpaceUri(node, content, namespaceURI);
                        content = EndpointReferenceUtils.getService(content);
                    } else {
                        Node nodeAttr = node.getAttributes().getNamedItem("xmlns");
                        namespaceURI = nodeAttr.getNodeValue();
                    }
                    return new QName(namespaceURI, content);
                }
                if (obj instanceof JAXBElement) {
                    Object val = ((JAXBElement)obj).getValue();
                    if (!(val instanceof AttributedQNameType)) continue;
                    return ((AttributedQNameType)val).getValue();
                }
                if (!(obj instanceof AttributedQNameType)) continue;
                return ((AttributedQNameType)obj).getValue();
            }
        }
        return null;
    }

    public static void setWSDLLocation(EndpointReferenceType ref, String ... wsdlLocation) {
        MetadataType metadata = ref.getMetadata();
        if (null == metadata) {
            metadata = new MetadataType();
            ref.setMetadata(metadata);
        }
        StringBuffer strBuf = new StringBuffer();
        for (String str : wsdlLocation) {
            strBuf.append(str);
            strBuf.append(" ");
        }
        metadata.getOtherAttributes().put(WSDL_LOCATION, strBuf.toString().trim());
    }

    public static String getWSDLLocation(EndpointReferenceType ref) {
        String wsdlLocation = null;
        MetadataType metadata = ref.getMetadata();
        if (metadata != null) {
            wsdlLocation = (String)metadata.getOtherAttributes().get(WSDL_LOCATION);
        }
        if (null == wsdlLocation) {
            return null;
        }
        return wsdlLocation;
    }

    public static void setMetadata(EndpointReferenceType ref, List<Source> metadata) throws EndpointUtilsException {
        if (null != ref) {
            MetadataType mt = ref.getMetadata();
            if (null == mt) {
                mt = new MetadataType();
                ref.setMetadata(mt);
            }
            List anyList = mt.getAny();
            try {
                for (Source source : metadata) {
                    Node node = null;
                    boolean doTransform = true;
                    if (source instanceof StreamSource) {
                        StreamSource ss = (StreamSource)source;
                        if (null == ss.getInputStream() && null == ss.getReader()) {
                            EndpointReferenceUtils.setWSDLLocation(ref, ss.getSystemId());
                            doTransform = false;
                        }
                    } else if (source instanceof DOMSource) {
                        node = ((DOMSource)((Object)node)).getNode();
                        doTransform = false;
                    }
                    if (doTransform) {
                        DOMResult domResult = new DOMResult();
                        domResult.setSystemId(source.getSystemId());
                        EndpointReferenceUtils.getTransformer().transform(source, domResult);
                        node = domResult.getNode();
                    }
                    if (null == node) continue;
                    if (node instanceof Document) {
                        ((Document)node).setDocumentURI(source.getSystemId());
                        node = node.getFirstChild();
                    }
                    while (node.getNodeType() != 1) {
                        node = node.getNextSibling();
                    }
                    anyList.add(node);
                }
            }
            catch (TransformerException te) {
                throw new EndpointUtilsException(new Message("COULD_NOT_POPULATE_EPR", LOG, new Object[0]), te);
            }
        }
    }

    public static Definition getWSDLDefinition(WSDLManager manager, EndpointReferenceType ref) throws WSDLException {
        if (null == manager) {
            return null;
        }
        MetadataType metadata = ref.getMetadata();
        String location = EndpointReferenceUtils.getWSDLLocation(ref);
        if (null != location) {
            return manager.getDefinition(location);
        }
        for (Object obj : metadata.getAny()) {
            Element el;
            if (!(obj instanceof Element) || !StringUtils.isEqualUri((String)(el = (Element)obj).getNamespaceURI(), (String)"http://schemas.xmlsoap.org/wsdl") || !"definitions".equals(el.getLocalName())) continue;
            return manager.getDefinition(el);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema getSchema(ServiceInfo serviceInfo) {
        Schema schema;
        block12: {
            if (serviceInfo == null) {
                return null;
            }
            WeakHashMap<ServiceInfo, Schema> weakHashMap = schemaMap;
            synchronized (weakHashMap) {
                if (schemaMap.containsKey(serviceInfo)) {
                    return schemaMap.get(serviceInfo);
                }
            }
            schema = schemaMap.get(serviceInfo);
            if (schema == null) {
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                ArrayList<DOMSource> schemaSources = new ArrayList<DOMSource>();
                for (SchemaInfo schemaInfo : serviceInfo.getTypeInfo().getSchemas()) {
                    DOMSource source = new DOMSource(schemaInfo.getElement());
                    source.setSystemId(schemaInfo.getElement().getBaseURI());
                    if (source == null) continue;
                    schemaSources.add(source);
                }
                try {
                    schema = factory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
                    if (schema == null) break block12;
                    WeakHashMap<ServiceInfo, Schema> i$ = schemaMap;
                    synchronized (i$) {
                        schemaMap.put(serviceInfo, schema);
                    }
                    LOG.log(Level.FINE, "Obtained schema from ServiceInfo");
                }
                catch (SAXException ex) {
                    LOG.log(Level.WARNING, "SAXException for newSchema()", ex);
                }
            }
        }
        return schema;
    }

    public static Port getPort(WSDLManager manager, EndpointReferenceType ref) throws WSDLException {
        Service service;
        Definition def = EndpointReferenceUtils.getWSDLDefinition(manager, ref);
        if (def == null) {
            throw new WSDLException("OTHER_ERROR", "unable to find definition for reference");
        }
        MetadataType metadata = ref.getMetadata();
        for (Object obj : metadata.getAny()) {
            String endpoint;
            Object jaxbVal;
            if (!(obj instanceof JAXBElement) || !((jaxbVal = ((JAXBElement)obj).getValue()) instanceof ServiceNameType)) continue;
            Port port = null;
            ServiceNameType snt = (ServiceNameType)jaxbVal;
            LOG.log(Level.FINEST, "found service name " + snt.getValue().getLocalPart());
            Service service2 = def.getService(snt.getValue());
            if (service2 == null) {
                LOG.log(Level.WARNING, "can't find the service name [" + snt.getValue() + "], using the default service name in wsdl");
                service2 = (Service)def.getServices().values().iterator().next();
                if (service2 == null) {
                    return null;
                }
            }
            if ((port = "".equals(endpoint = snt.getEndpointName()) && service2.getPorts().size() == 1 ? (Port)service2.getPorts().values().iterator().next() : service2.getPort(endpoint)) == null) {
                LOG.log(Level.WARNING, "can't find the port name [" + endpoint + "], using the default port name in wsdl");
                port = (Port)service2.getPorts().values().iterator().next();
            }
            return port;
        }
        if (def.getServices().size() == 1 && (service = (Service)def.getServices().values().iterator().next()).getPorts().size() == 1) {
            return (Port)service.getPorts().values().iterator().next();
        }
        QName serviceName = EndpointReferenceUtils.getServiceName(ref);
        if (null != serviceName) {
            Service service3 = def.getService(serviceName);
            if (service3 == null) {
                throw new WSDLException("OTHER_ERROR", "Cannot find service for " + serviceName);
            }
            if (service3.getPorts().size() == 1) {
                return (Port)service3.getPorts().values().iterator().next();
            }
            String str = EndpointReferenceUtils.getPortName(ref);
            LOG.log(Level.FINE, "getting port " + str + " from service " + service3.getQName());
            Port port = service3.getPort(str);
            if (port == null) {
                throw new WSDLException("OTHER_ERROR", "unable to find port " + str);
            }
            return port;
        }
        return null;
    }

    public static String getAddress(EndpointReferenceType ref) {
        AttributedURIType a = ref.getAddress();
        if (null != a) {
            return a.getValue();
        }
        return null;
    }

    public static void setAddress(EndpointReferenceType ref, String address) {
        AttributedURIType a = new ObjectFactory().createAttributedURIType();
        a.setValue(address);
        ref.setAddress(a);
    }

    public static EndpointReferenceType getEndpointReference(URL wsdlUrl, QName serviceName, String portName) {
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setMetadata(new MetadataType());
        EndpointReferenceUtils.setServiceAndPortName(reference, serviceName, portName);
        EndpointReferenceUtils.setWSDLLocation(reference, wsdlUrl.toString());
        return reference;
    }

    public static EndpointReferenceType getEndpointReference(String address) {
        EndpointReferenceType reference = new EndpointReferenceType();
        EndpointReferenceUtils.setAddress(reference, address);
        return reference;
    }

    public static WebService getWebServiceAnnotation(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        WebService ws = cls.getAnnotation(WebService.class);
        if (null != ws) {
            return ws;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            ws = EndpointReferenceUtils.getWebServiceAnnotation(inf);
            if (null == ws) continue;
            return ws;
        }
        return EndpointReferenceUtils.getWebServiceAnnotation(cls.getSuperclass());
    }

    public static EndpointReferenceType getEndpointReference(WSDLManager manager, Object implementor) {
        return EndpointReferenceUtils.getEndpointReference(manager, implementor.getClass());
    }

    private static String getNameSpaceUri(Node node, String content, String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = node.lookupNamespaceURI(content.substring(0, content.indexOf(":")));
        }
        return namespaceURI;
    }

    private static String getService(String content) {
        return content.substring(content.indexOf(":") + 1, content.length());
    }
}

