/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common.model;

import com.sun.xml.bind.api.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaParameter;
import org.apache.cxf.tools.common.model.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLParameter {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLParameter.class);
    protected String name;
    protected String type;
    protected String className;
    protected String targetNamespace;
    protected final List<JavaParameter> parts = new ArrayList<JavaParameter>();
    private TypeReference typeRef;
    private JavaType.Style style;
    private String pname;

    public WSDLParameter() {
    }

    public WSDLParameter(String paraName, TypeReference ref, JavaType.Style paraStyle) {
        this.pname = paraName;
        this.typeRef = ref;
        this.style = paraStyle;
    }

    public void setName(String arg) {
        this.pname = arg;
    }

    public void setClassName(String clzName) {
        this.className = clzName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setTargetNamespace(String tns) {
        this.targetNamespace = tns;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public JavaType.Style getStyle() {
        return this.style;
    }

    public void setStyle(JavaType.Style s) {
        this.style = s;
    }

    public String getName() {
        return this.pname;
    }

    public void setTypeReference(TypeReference ref) {
        this.typeRef = ref;
    }

    public TypeReference getTypeReference() {
        return this.typeRef;
    }

    public boolean isWrapped() {
        return true;
    }

    public List<JavaParameter> getChildren() {
        return Collections.unmodifiableList(this.parts);
    }

    public void addChildren(JavaParameter jp) {
        if (this.parts.contains(jp)) {
            Message message = new Message("PART_ALREADY_EXIST", LOG, new Object[]{jp.getName()});
            throw new ToolException(message);
        }
        this.parts.add(jp);
    }

    public JavaParameter removeChildren(int index) {
        return this.parts.remove(index);
    }

    public void clear() {
        this.parts.clear();
    }
}

