/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class RPCInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final Logger LOG = Logger.getLogger(RPCInInterceptor.class.getName());

    public RPCInInterceptor() {
        this.setPhase("unmarshal");
        this.addAfter(URIMappingInterceptor.class.getName());
    }

    private BindingOperationInfo getOperation(Message message, QName opName) {
        return ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)opName);
    }

    public void handleMessage(Message message) {
        if (this.isGET(message)) {
            LOG.info("RPCInInterceptor skipped in HTTP GET method");
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        BindingOperationInfo operation = null;
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            message.setContent(Exception.class, (Object)new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        if (message.getExchange().get(BindingOperationInfo.class) == null) {
            operation = this.getOperation(message, new QName(xmlReader.getNamespaceURI(), opName));
            if (operation == null) {
                new BareInInterceptor().handleMessage(message);
            }
            message.getExchange().put(BindingOperationInfo.class, (Object)operation);
        } else {
            operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        }
        DataReader dr = this.getMessageDataReader(message);
        MessageInfo msg = !this.isRequestor(message) ? operation.getOperationInfo().getInput() : operation.getOperationInfo().getOutput();
        ArrayList<Object> parameters = new ArrayList<Object>();
        StaxUtils.nextEvent((XMLStreamReader)xmlReader);
        while (StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            QName name = xmlReader.getName();
            int idx = parameters.size();
            MessagePartInfo p = (MessagePartInfo)msg.getMessageParts().get(idx);
            if (p == null) {
                throw new SoapFault("Parameter " + xmlReader.getName() + " does not exist!", ((SoapMessage)message).getVersion().getSender());
            }
            QName elName = new QName(operation.getOperationInfo().getName().getNamespaceURI(), p.getName().getLocalPart());
            if (!elName.getLocalPart().equals(name.getLocalPart())) {
                String expMessage = "Parameter " + name + " is not equal to the name [" + elName.getLocalPart() + "] in the servicemodel!";
                throw new SoapFault(expMessage, ((SoapMessage)message).getVersion().getSender());
            }
            Object param = null;
            param = dr.read(p, (Object)message);
            if (param != null) {
                parameters.add(param);
                continue;
            }
            throw new RuntimeException(p.getName() + " can not be unmarshalled");
        }
        message.setContent(List.class, parameters);
    }
}

