/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.transport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.transport.JBIConduitOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public class JBIConduit
implements Conduit {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIConduit.class);
    private MessageObserver incomingObserver;
    private EndpointReferenceType target;
    private DeliveryChannel channel;

    public JBIConduit(EndpointReferenceType target, DeliveryChannel dc) {
        this.target = target;
        this.channel = dc;
    }

    public void send(Message message) throws IOException {
        LOG.log(Level.FINE, "JBIConduit send message");
        message.setContent(OutputStream.class, (Object)new JBIConduitOutputStream(message, this.channel, this.target, this));
    }

    public void close(Message message) throws IOException {
        ((OutputStream)message.getContent(OutputStream.class)).close();
    }

    public EndpointReferenceType getTarget() {
        return this.target;
    }

    public Destination getBackChannel() {
        return null;
    }

    public void close() {
    }

    public void setMessageObserver(MessageObserver observer) {
        this.incomingObserver = observer;
    }

    public MessageObserver getMessageObserver() {
        return this.incomingObserver;
    }
}

