/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactoryHelper;
import org.apache.cxf.binding.soap.SoapBindingInfoFactoryBean;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.wsdl11.WSDLEndpointFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointFactory {
    private Bus bus;
    private String address;
    private String transportId;
    private AbstractBindingInfoFactoryBean bindingFactory;
    private Class serviceClass;
    private DestinationFactory destinationFactory;
    private ReflectionServiceFactoryBean serviceFactory;
    private QName endpointName;
    private Map<String, Object> properties;

    protected Endpoint createEndpoint() throws BusException, EndpointException {
        Service service = this.serviceFactory.getService();
        if (service == null) {
            this.serviceFactory.setServiceClass(this.getServiceClass());
            this.serviceFactory.setBus(this.getBus());
            service = this.serviceFactory.create();
        }
        if (this.endpointName == null) {
            this.endpointName = this.serviceFactory.getEndpointName();
        }
        EndpointInfo ei = service.getServiceInfo().getEndpoint(this.endpointName);
        Endpoint ep = null;
        if (ei == null) {
            ei = this.createEndpointInfo();
        } else if (this.getAddress() != null) {
            ei.setAddress(this.getAddress());
        }
        this.setProps(ei);
        ep = (Endpoint)service.getEndpoints().get(ei.getName());
        if (ep == null) {
            ep = this.serviceFactory.createEndpoint(ei);
        }
        service.getEndpoints().put(ep.getEndpointInfo().getName(), ep);
        return ep;
    }

    private void setProps(EndpointInfo ei) {
        if (this.properties == null) {
            return;
        }
        for (Map.Entry<String, Object> e : this.properties.entrySet()) {
            ei.setProperty(e.getKey(), e.getValue());
        }
    }

    protected EndpointInfo createEndpointInfo() throws BusException {
        DestinationFactoryManager dfm;
        if (this.transportId == null) {
            DestinationFactory df;
            if (this.getAddress() != null && (df = (dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class)).getDestinationFactoryForUri(this.getAddress())) != null) {
                this.transportId = (String)df.getTransportIds().get(0);
            }
            if (this.transportId == null) {
                this.transportId = "http://schemas.xmlsoap.org/wsdl/soap/http";
            }
        }
        if (this.getBindingFactory() instanceof SoapBindingInfoFactoryBean) {
            ((SoapBindingInfoFactoryBean)this.getBindingFactory()).setTransportURI(this.transportId);
            this.transportId = "http://schemas.xmlsoap.org/wsdl/soap/";
        }
        this.setTransportId(this.transportId);
        dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class);
        this.destinationFactory = dfm.getDestinationFactory(this.transportId);
        Service service = this.serviceFactory.getService();
        this.getBindingFactory().setServiceFactory((AbstractServiceFactoryBean)this.serviceFactory);
        BindingInfo bindingInfo = this.getBindingFactory().create();
        service.getServiceInfo().addBinding(bindingInfo);
        EndpointInfo ei = new EndpointInfo(service.getServiceInfo(), this.transportId);
        ei.setName(this.endpointName);
        ei.setAddress(this.getAddress());
        ei.setBinding(bindingInfo);
        if (this.destinationFactory instanceof WSDLEndpointFactory) {
            WSDLEndpointFactory we = (WSDLEndpointFactory)this.destinationFactory;
            we.createPortExtensors(ei, service);
        }
        service.getServiceInfo().addEndpoint(ei);
        return ei;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Bus getBus() {
        if (this.bus == null) {
            this.bus = BusFactoryHelper.newInstance().getDefaultBus();
        }
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public String getTransportId() {
        return this.transportId;
    }

    public void setTransportId(String transportId) {
        this.transportId = transportId;
    }

    public AbstractBindingInfoFactoryBean getBindingFactory() {
        return this.bindingFactory;
    }

    public void setBindingFactory(AbstractBindingInfoFactoryBean bindingFactory) {
        this.bindingFactory = bindingFactory;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public DestinationFactory getDestinationFactory() {
        return this.destinationFactory;
    }

    public void setDestinationFactory(DestinationFactory destinationFactory) {
        this.destinationFactory = destinationFactory;
    }

    public ReflectionServiceFactoryBean getServiceFactory() {
        return this.serviceFactory;
    }

    public void setServiceFactory(ReflectionServiceFactoryBean serviceFactory) {
        this.serviceFactory = serviceFactory;
    }

    public QName getEndpointName() {
        return this.endpointName;
    }

    public void setEndpointName(QName endpointName) {
        this.endpointName = endpointName;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

