/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.io.IOException;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.SoapBindingInfoFactoryBean;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.factory.AbstractEndpointFactory;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.transport.ChainInitiationObserver;
import org.apache.cxf.transport.MessageObserver;

public class ServerFactoryBean
extends AbstractEndpointFactory {
    private Server server;
    private boolean start = true;

    public ServerFactoryBean() {
        this.setBindingFactory((AbstractBindingInfoFactoryBean)new SoapBindingInfoFactoryBean());
        this.setServiceFactory(new ReflectionServiceFactoryBean());
    }

    public String getBeanName() {
        return this.getClass().getName();
    }

    public Server create() {
        try {
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, (MessageObserver)new ChainInitiationObserver(ep, this.getBus()));
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        return this.server;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

