/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.AbstractBindingFactory;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.xml.XMLBinding;
import org.apache.cxf.binding.xml.interceptor.XMLFaultInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLFaultOutInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageInInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageOutInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.URIMappingInterceptor;
import org.apache.cxf.service.model.BindingInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBindingFactory
extends AbstractBindingFactory {
    private Map cachedBinding = new HashMap();
    private Bus bus;
    private Collection<String> activationNamespaces;

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    @Resource
    public void setActivationNamespaces(Collection<String> ans) {
        this.activationNamespaces = ans;
    }

    @PostConstruct
    void register() {
        if (null == this.bus) {
            return;
        }
        BindingFactoryManager bfm = (BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class);
        if (null != bfm) {
            for (String ns : this.activationNamespaces) {
                bfm.registerBindingFactory(ns, (BindingFactory)this);
            }
        }
    }

    public Binding createBinding(BindingInfo binding) {
        if (this.cachedBinding.get(binding) != null) {
            return (Binding)this.cachedBinding.get(binding);
        }
        XMLBinding xb = new XMLBinding();
        xb.getInInterceptors().add(new StaxInInterceptor());
        xb.getInInterceptors().add(new XMLMessageInInterceptor());
        xb.getInFaultInterceptors().add(new XMLFaultInInterceptor());
        xb.getOutInterceptors().add(new StaxOutInterceptor());
        xb.getOutInterceptors().add(new XMLMessageOutInterceptor());
        xb.getOutFaultInterceptors().add(new StaxOutInterceptor());
        xb.getOutFaultInterceptors().add(new XMLFaultOutInterceptor());
        xb.getInInterceptors().add(new URIMappingInterceptor());
        return xb;
    }
}

