/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml.interceptor;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.xml.XMLFault;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;

public class XMLFaultOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLFaultOutInterceptor.class);

    public XMLFaultOutInterceptor() {
        this.setPhase("marshal");
    }

    public void handleMessage(Message message) throws Fault {
        message.put((Object)Message.RESPONSE_CODE, (Object)new Integer(500));
        NSStack nsStack = new NSStack();
        nsStack.push();
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        Fault f = (Fault)message.getContent(Exception.class);
        XMLFault xmlFault = XMLFault.createFault(f);
        try {
            nsStack.add("http://cxf.apache.org/bindings/xformat");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"XMLFault", (String)"http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"faultstring", (String)"http://cxf.apache.org/bindings/xformat");
            Throwable t = xmlFault.getCause();
            writer.writeCharacters(t == null ? xmlFault.getMessage() : t.toString());
            writer.writeEndElement();
            BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
            if (t != null && bop != null) {
                if (bop.isUnwrapped()) {
                    bop = bop.getWrappedOperation();
                }
                Iterator it = bop.getOperationInfo().getFaults().iterator();
                MessagePartInfo part = null;
                block4: while (it.hasNext()) {
                    FaultInfo fi = (FaultInfo)it.next();
                    for (MessagePartInfo mpi : fi.getMessageParts()) {
                        Class cls = mpi.getTypeClass();
                        try {
                            Method method = t.getClass().getMethod("getFaultInfo", new Class[0]);
                            Class<?> sub = method.getReturnType();
                            if (cls == null || !cls.equals(sub)) continue;
                            part = mpi;
                            continue block4;
                        }
                        catch (NoSuchMethodException ne) {
                        }
                    }
                }
                if (part != null) {
                    StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"detail", (String)"http://cxf.apache.org/bindings/xformat");
                    DataWriter dataWriter = this.getMessageDataWriter(message);
                    dataWriter.write(XMLFaultOutInterceptor.getFaultInfo(t), part, (Object)message);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    private static Object getFaultInfo(Throwable fault) {
        try {
            Method faultInfoMethod = fault.getClass().getMethod("getFaultInfo", new Class[0]);
            if (faultInfoMethod != null) {
                return faultInfoMethod.invoke((Object)fault, new Object[0]);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not get faultInfo out of Exception", ex);
        }
        return null;
    }
}

