/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.misc.processor;

import com.sun.tools.xjc.api.ErrorListener;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.Processor;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.WSDLExtensionRegister;
import org.apache.cxf.tools.validator.internal.WSDL11Validator;
import org.xml.sax.SAXParseException;

public class AbstractWSDLToProcessor
implements Processor,
ErrorListener {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractWSDLToProcessor.class);
    protected static final String WSDL_FILE_NAME_EXT = ".wsdl";
    protected Definition wsdlDefinition;
    protected ToolContext env;
    protected WSDLFactory wsdlFactory;
    protected WSDLReader wsdlReader;
    protected ClassCollector classColletor;
    List<Schema> schemaList = new ArrayList<Schema>();
    private List<Definition> importedDefinitions = new ArrayList<Definition>();

    protected Writer getOutputWriter(String newNameExt) throws ToolException {
        String outputDir;
        Writer writer = null;
        String newName = null;
        if (this.env.get("outputfile") != null) {
            newName = (String)this.env.get("outputfile");
        } else {
            String oldName = (String)this.env.get("wsdlurl");
            int position = oldName.lastIndexOf("/");
            if (position < 0) {
                position = oldName.lastIndexOf("\\");
            }
            if (position >= 0) {
                oldName = oldName.substring(position + 1, oldName.length());
            }
            newName = oldName.toLowerCase().indexOf(WSDL_FILE_NAME_EXT) >= 0 ? oldName.substring(0, oldName.length() - 5) + newNameExt + WSDL_FILE_NAME_EXT : oldName + newNameExt;
        }
        if (this.env.get("outputdir") != null) {
            outputDir = (String)this.env.get("outputdir");
            if (!"/".equals(outputDir.substring(outputDir.length() - 1)) && !"\\".equals(outputDir.substring(outputDir.length() - 1))) {
                outputDir = outputDir + "/";
            }
        } else {
            outputDir = "./";
        }
        FileWriterUtil fw = new FileWriterUtil(outputDir);
        try {
            writer = fw.getWriter("", newName);
        }
        catch (IOException ioe) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("FAIL_TO_WRITE_FILE", LOG, new Object[]{this.env.get("outputdir") + System.getProperty("file.seperator") + newName});
            throw new ToolException(msg, (Throwable)ioe);
        }
        return writer;
    }

    protected void parseWSDL(String wsdlURL) throws ToolException {
        try {
            this.wsdlFactory = WSDLFactory.newInstance();
            this.wsdlReader = this.wsdlFactory.newWSDLReader();
            this.wsdlReader.setFeature("javax.wsdl.verbose", false);
            WSDLExtensionRegister register = new WSDLExtensionRegister(this.wsdlFactory, this.wsdlReader);
            register.registerExtensions();
            this.wsdlDefinition = this.wsdlReader.readWSDL(wsdlURL);
            this.parseImports(this.wsdlDefinition);
            this.buildWSDLDefinition();
        }
        catch (WSDLException we) {
            org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("FAIL_TO_CREATE_WSDL_DEFINITION", LOG, new Object[]{wsdlURL});
            throw new ToolException(msg, (Throwable)we);
        }
    }

    private void buildWSDLDefinition() {
        for (Definition def : this.importedDefinitions) {
            this.wsdlDefinition.addNamespace(def.getPrefix(def.getTargetNamespace()), def.getTargetNamespace());
            Object[] services = def.getServices().values().toArray();
            for (int i = 0; i < services.length; ++i) {
                this.wsdlDefinition.addService((Service)services[i]);
            }
            Object[] messages = def.getMessages().values().toArray();
            for (int i = 0; i < messages.length; ++i) {
                this.wsdlDefinition.addMessage((Message)messages[i]);
            }
            Object[] bindings = def.getBindings().values().toArray();
            for (int i = 0; i < bindings.length; ++i) {
                this.wsdlDefinition.addBinding((Binding)bindings[i]);
            }
            Object[] portTypes = def.getPortTypes().values().toArray();
            for (int i = 0; i < portTypes.length; ++i) {
                this.wsdlDefinition.addPortType((PortType)portTypes[i]);
            }
        }
    }

    private void parseImports(Definition def) {
        ArrayList importList = new ArrayList();
        Map imports = def.getImports();
        for (String uri : imports.keySet()) {
            importList.addAll((List)imports.get(uri));
        }
        for (Import impt : importList) {
            this.parseImports(impt.getDefinition());
            this.importedDefinitions.add(impt.getDefinition());
        }
    }

    protected void init() throws ToolException {
    }

    public Definition getWSDLDefinition() {
        return this.wsdlDefinition;
    }

    public void process() throws ToolException {
    }

    public void validateWSDL() throws ToolException {
        if (this.env.validateWSDL()) {
            WSDL11Validator validator = new WSDL11Validator(this.wsdlDefinition, this.env);
            validator.isValid();
        }
    }

    public void setEnvironment(ToolContext penv) {
        this.env = penv;
    }

    public ToolContext getEnvironment() {
        return this.env;
    }

    public void error(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema error: \n" + exception.toString());
        }
    }

    public void fatalError(SAXParseException exception) {
        if (this.env.isVerbose()) {
            exception.printStackTrace();
        } else {
            System.err.println("Parsing schema fatal error: \n" + exception.toString());
        }
    }

    public void info(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema info: " + exception.toString());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.env.isVerbose()) {
            System.err.println("Parsing schema warning " + exception.toString());
        }
    }
}

