/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BusFactoryHelper {
    private static final Logger LOG = LogUtils.getL7dLogger(BusFactoryHelper.class, (String)"APIMessages");

    private BusFactoryHelper() {
    }

    public static BusFactory newInstance() {
        BusFactory instance = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String className = BusFactoryHelper.getBusFactoryClass(null, classLoader);
        try {
            Class<BusFactory> busFactoryClass = Class.forName(className, true, classLoader).asSubclass(BusFactory.class);
            instance = busFactoryClass.newInstance();
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"BUS_FACTORY_INSTANTIATION_EXC", (Throwable)ex, (Object[])new Object[0]);
        }
        return instance;
    }

    private static String getBusFactoryClass(Map<String, Object> properties, ClassLoader classLoader) {
        String busFactoryClass = null;
        if (null != properties && BusFactoryHelper.isValidBusFactoryClass(busFactoryClass = (String)properties.get("org.apache.cxf.bus.factory"))) {
            return busFactoryClass;
        }
        busFactoryClass = System.getProperty("org.apache.cxf.bus.factory");
        if (BusFactoryHelper.isValidBusFactoryClass(busFactoryClass)) {
            return busFactoryClass;
        }
        try {
            String serviceId = "META-INF/services/org.apache.cxf.bus.factory";
            InputStream is = null;
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            if ((is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId)) != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                busFactoryClass = rd.readLine();
                rd.close();
            }
            if (BusFactoryHelper.isValidBusFactoryClass(busFactoryClass)) {
                return busFactoryClass;
            }
            busFactoryClass = "org.apache.cxf.bus.CXFBusFactory";
            return busFactoryClass;
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"FAILED_TO_DETERMINE_BUS_FACTORY_EXC", (Throwable)ex, (Object[])new Object[0]);
            return busFactoryClass;
        }
    }

    private static boolean isValidBusFactoryClass(String busFactoryClassName) {
        return busFactoryClassName != null && !"".equals(busFactoryClassName);
    }
}

