/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl;

import java.io.InputStream;
import java.util.HashSet;
import javax.wsdl.Definition;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolRunner;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;

public class JavaToWSDL
extends AbstractCXFToolContainer {
    private static final String TOOL_NAME = "java2wsdl";
    private static String[] args;
    private static Definition definition;

    public JavaToWSDL(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        JavaToWSDLProcessor processor = new JavaToWSDLProcessor();
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(new HashSet()));
                if (this.isVerboseOn()) {
                    env.put("verbose", (Object)Boolean.TRUE);
                }
                processor.setEnvironment(env);
                processor.process();
                definition = processor.getModel().getDefinition();
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                JavaToWSDL.getInstance().printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new ToolException(ex.getMessage(), ex.getCause());
        }
    }

    public static void main(String[] pargs) {
        block4: {
            try {
                JavaToWSDL.runTool(pargs);
            }
            catch (BadUsageException ex) {
                System.err.println("Error : " + ex.getMessage());
                JavaToWSDL.getInstance().printUsageException(TOOL_NAME, ex);
                if (JavaToWSDL.getInstance().isVerboseOn()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                System.err.println("Error : " + ex.getMessage());
                System.err.println();
                if (!JavaToWSDL.getInstance().isVerboseOn()) break block4;
                ex.printStackTrace();
            }
        }
    }

    public static void runTool(String[] pargs) throws Exception {
        args = pargs;
        ToolRunner.runTool(JavaToWSDL.class, (InputStream)JavaToWSDL.class.getResourceAsStream("java2wsdl.xml"), (boolean)false, (String[])args);
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }

    public static Definition getDefinition() {
        return definition;
    }
}

