/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.logging.Logger;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.WSDLModel;
import org.apache.cxf.tools.java2wsdl.processor.JavaToWSDLProcessor;

public class WSDLOutputResolver
extends SchemaOutputResolver {
    private static final Logger LOG = LogUtils.getL7dLogger(JavaToWSDLProcessor.class);
    private final ToolContext env;
    private final WSDLModel wmodel;

    public WSDLOutputResolver(ToolContext penv, WSDLModel model) {
        this.env = penv;
        this.wmodel = model;
    }

    private File getFile(String filename) {
        Object obj = this.env.get("outputfile");
        String wsdlFile = obj == null ? "./" : (String)obj;
        File file = null;
        file = wsdlFile != null ? ((file = new File(wsdlFile)).isDirectory() ? new File(file, filename) : new File(file.getParent(), filename)) : new File(".", filename);
        return file;
    }

    public Result createOutput(String namespaceUri, String suggestedFileName) {
        this.wmodel.addSchemaNSFileToMap(namespaceUri, suggestedFileName);
        File wsdlFile = this.getFile(suggestedFileName);
        StreamResult result = null;
        try {
            result = new StreamResult(new FileOutputStream(wsdlFile));
            result.setSystemId(wsdlFile.toString().replace('\\', '/'));
        }
        catch (FileNotFoundException e) {
            Message msg = new Message("CANNOT_CREATE_SCHEMA_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
        return result;
    }
}

